#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    # Instanciate one distribution object
    distribution = Epanechnikov()
    print "Distribution " , distribution 

    # Is this distribution elliptical ?
    print "Elliptical = ", distribution.isElliptical()

    # Is this distribution continuous ?
    print "Continuous = ", distribution.isContinuous()

    # Test for realization of distribution
    oneRealization = distribution.getRealization()
    print "oneRealization=", oneRealization 
 
    # Test for sampling
    size = 10000
    oneSample = distribution.getNumericalSample( size )
    print "oneSample first=" , oneSample[0] , " last=" , oneSample[size - 1] 
    print "mean=" , oneSample.computeMean() 
    print "covariance=" , oneSample.computeCovariance()

    # Define a point
    point = NumericalPoint( distribution.getDimension() , 1.0)
    print "Point= " , point 

    # Show PDF and CDF of point
    eps = 1e-5
        
    # derivative of PDF with regards its arguments
    DDF = distribution.computeDDF( point )
    print "ddf     =" , DDF
    # by the finite difference technique
    print "ddf (FD)=" , NumericalPoint(1, (distribution.computePDF( point + NumericalPoint(1, eps) ) - distribution.computePDF( point  + NumericalPoint(1, -eps) )) / (2.0 * eps))

    # PDF value
    PDF = distribution.computePDF( point )
    print "pdf     =%.6f" % PDF 
    # by the finite difference technique from CDF
    print "pdf (FD)=%.6f" % ((distribution.computeCDF( point + NumericalPoint(1, eps) ) - distribution.computeCDF( point  + NumericalPoint(1, -eps) )) / (2.0 * eps))

    # derivative of the PDF with regards the parameters of the distribution
    CDF = distribution.computeCDF( point )
    print "cdf=%.6f" % CDF 
    PDFgr = distribution.computePDFGradient( point )
    print "pdf gradient     =" , PDFgr 
    
    # derivative of the CDF with regards the parameters of the distribution
    CDFgr = distribution.computeCDFGradient( point )
    print "cdf gradient     =" , CDFgr 

    # quantile
    quantile = distribution.computeQuantile( 0.95 )
    print "quantile=" , quantile 
    print "cdf(quantile)=%.6f" % distribution.computeCDF(quantile) 
    mean = distribution.getMean()
    print "mean=" , mean 
    standardDeviation = distribution.getStandardDeviation()
    print "standard deviation=" , standardDeviation 
    skewness = distribution.getSkewness()
    print "skewness=" , skewness 
    kurtosis = distribution.getKurtosis()
    print "kurtosis=" , kurtosis 
    covariance = distribution.getCovariance()
    print "covariance=" , covariance 
    parameters = distribution.getParametersCollection()
    print "parameters=" , parameters 
                        
except :
  import sys
  print "t_Epanechnikov_std.py", sys.exc_type, sys.exc_value

