#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :
    # Instanciate one distribution object 
    dim = 3

    copula = IndependentCopula(dim)
    print "Copula =", copula

    # Is this copula an elliptical distribution?
    print "Elliptical distribution = ", copula.isElliptical()

    # Is this copula continuous ?
    print "Continuous copula = ",  copula.isContinuous() 

    # Is this copula elliptical ?
    print "Elliptical copula = ", copula.hasEllipticalCopula()

    # Is this copula independant ?
    print "hasIndependentCopula = ",copula.hasIndependentCopula()

    # Test for realization of copula
    oneRealization = copula.getRealization()
    print "oneRealization=", oneRealization 

    # Test for sampling
    size = 10000
    oneSample = copula.getNumericalSample( size )
    print "oneSample first=" , oneSample[0] , " last=" , oneSample[size - 1] 
    print "mean=" , oneSample.computeMean() 
    print "covariance=" , oneSample.computeCovariance() 

    # Define a point
    point = NumericalPoint(copula.getDimension(), 0.6)
    print "Point= " , point 

    # Show PDF and CDF of point
    
    # derivative of PDF with regards its arguments
    DDF = copula.computeDDF( point )
    print "ddf     =" , DDF 

    # PDF value
    PDF = copula.computePDF( point )
    print "pdf     =%.6f" % PDF 

    # CDF value
    CDF = copula.computeCDF( point )
    print "cdf=%.6f" % CDF  

    # derivative of the PDF with regards the parameters of the distribution
    PDFgr = copula.computePDFGradient( point )
    print "pdf gradient     =" , PDFgr  

    # derivative of the CDF with regards the parameters of the distribution
    CDFgr = copula.computeCDFGradient( point )
    print "cdf gradient     =" , CDFgr

    # quantile
    quantile = copula.computeQuantile( 0.95 )
    print "quantile=" , quantile 
    print "cdf(quantile)=%.6f" % copula.computeCDF(quantile)

    # mean
    mean = copula.getMean()
    print "mean=" , mean

    # covariance
    covariance = copula.getCovariance()
    print "covariance=" , covariance

    # parameters of the distribution
    parameters = copula.getParametersCollection()
    print "parameters=" , parameters 

    # Specific to this copula

    # Extract the marginals
    for i in range(dim) :
        margin = Copula(Copula(copula).getMarginal(i))
        print "margin=", margin
        print "margin PDF=%.6f" % margin.computePDF(NumericalPoint(1,0.25))
        print "margin CDF=%.6f" % margin.computeCDF(NumericalPoint(1,0.25))
        print "margin quantile=", margin.computeQuantile(0.95)
        print "margin realization=", margin.getRealization()

    # Extract a 2-D marginal
    indices = Indices(2, 0)
    indices[0] = 1
    indices[1] = 0
    print "indices=", indices
    margins = Copula(Copula(copula).getMarginal(indices))
    print "margins=", margins
    print "margins PDF=%.6f" % margins.computePDF(NumericalPoint(2,0.25))
    print "margins CDF=%.6f" % margins.computeCDF(NumericalPoint(2,0.25))
    quantile = margins.computeQuantile(0.95)
    print "margins quantile=", quantile
    print "margins CDF(quantile)=%.6f" % margins.computeCDF(quantile) 
    print "margins realization=", margins.getRealization()
    
except :
  import sys
  print "t_IndependantCopula.py", sys.exc_type, sys.exc_value

