#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()
RandomGenerator().SetSeed(0)

try :

    # Instanciate one distribution object
    referenceDistribution = [TruncatedNormal(2.0, 1.5, 1.0, 4.0), TruncatedNormal(2.0, 1.5, 1.0, 200.0)]
    distribution = [TruncatedDistribution(Distribution(Normal(2.0, 1.5)), 1.0, 4.0), TruncatedDistribution(Distribution(Normal(2.0, 1.5)), 1.0, TruncatedDistribution.LOWER)]
    for testCase in range(2):
        print  "Distribution ", distribution[testCase] 

        # Is this distribution elliptical ?
        print "Elliptical = ", distribution[testCase].isElliptical()
        
        # Is this distribution continuous ?
        print "Continuous = ", distribution[testCase].isContinuous()
        
        # Test for realization of distribution
        oneRealization = distribution[testCase].getRealization()
        print "oneRealization=", oneRealization 
        
        # Test for sampling
        size = 10000
        oneSample = distribution[testCase].getNumericalSample( size )
        print "oneSample first=", oneSample[0], " last=", oneSample[size - 1] 
        print "mean=", oneSample.computeMean() 
        print "covariance=", oneSample.computeCovariance()
        
        # Define a point
        point = NumericalPoint( distribution[testCase].getDimension() , 2.5)
        print "Point= ", point 
        
        # Show PDF and CDF of point
        eps = 1e-5
        
        DDF = distribution[testCase].computeDDF( point )
        print "ddf      =", DDF
        print "ddf (ref)=", referenceDistribution[testCase].computeDDF( point )
        
        PDF = distribution[testCase].computePDF( point )
        print "pdf      =%.6f" % PDF 
        print "pdf (ref)=%.6f" % referenceDistribution[testCase].computePDF( point )
        
        CDF = distribution[testCase].computeCDF( point )
        print "cdf=%.6f" % CDF 
        print "cdf (ref)=%.6f" % referenceDistribution[testCase].computeCDF( point )
        PDFgr = distribution[testCase].computePDFGradient( point )
        print "pdf gradient      =", PDFgr
        print "pdf gradient (ref)=", referenceDistribution[testCase].computePDFGradient( point )
        
        CDFgr = distribution[testCase].computeCDFGradient( point )
        print "cdf gradient      =", CDFgr 
        print "cdf gradient (ref)=", referenceDistribution[testCase].computeCDFGradient( point )
        
        # quantile
        quantile = distribution[testCase].computeQuantile( 0.95 )
        print "quantile=", quantile 
        print "quantile=", referenceDistribution[testCase].computeQuantile( 0.95 )
        print "cdf(quantile)=%.6f" % distribution[testCase].computeCDF(quantile) 
        mean = distribution[testCase].getMean()
        print "mean      =", mean 
        print "mean (ref)=", referenceDistribution[testCase].getMean()
        standardDeviation = distribution[testCase].getStandardDeviation()
        print "standard deviation      =" , standardDeviation 
        print "standard deviation (ref)=", referenceDistribution[testCase].getStandardDeviation()
        skewness = distribution[testCase].getSkewness()
        print "skewness      =" , skewness 
        print "skewness (ref)=", referenceDistribution[testCase].getSkewness()
        kurtosis = distribution[testCase].getKurtosis()
        print "kurtosis      =" , kurtosis 
        print "kurtosis (ref)=", referenceDistribution[testCase].getKurtosis()
        covariance = distribution[testCase].getCovariance()
        print "covariance      =", covariance 
        print "covariance (ref)=", referenceDistribution[testCase].getCovariance ()
        parameters = distribution[testCase].getParametersCollection()
        print "parameters      =", parameters 
        print "parameters (ref)=", referenceDistribution[testCase].getParametersCollection()

except :
  import sys
  print "t_TruncatedNormal_std.py", sys.exc_type, sys.exc_value

