//                                               -*- C++ -*-
/**
 *  @file  ComparisonOperator.hxx
 *  @brief Abstract top-level class for all ComparisonOperator
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-09-22 11:34:11 +0200 (lun. 22 sept. 2008) $
 *  Id:      $Id: ComparisonOperator.hxx 941 2008-09-22 09:34:11Z dutka $
 */
#ifndef OPENTURNS_COMPARISONOPERATOR_HXX
#define OPENTURNS_COMPARISONOPERATOR_HXX

#include "TypedInterfaceObject.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      class ComparisonOperatorImplementation;


      /**
       * @class ComparisonOperator
       *
       * The class describes the probabilistic concept of ComparisonOperator.
       */
      class ComparisonOperator 
	: public TypedInterfaceObject<ComparisonOperatorImplementation>
      {
	CLASSNAME;
      public:

	/** Default constructor */
	ComparisonOperator();

	/** Constructor from implementation */
	ComparisonOperator(const ComparisonOperatorImplementation & op);


	/** Return true if comparison succeeds */
	Bool operator()(NumericalScalar a, NumericalScalar b) const;
	Bool compare(NumericalScalar a, NumericalScalar b) const;

    
      }; /* class ComparisonOperator */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPARISONOPERATOR_HXX */
