//                                               -*- C++ -*-
/**
 *  @file  GreaterOrEqual.cxx
 *  @brief Abstract top-level class for all GreaterOrEqual
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: GreaterOrEqual.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "GreaterOrEqual.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      CLASSNAMEINIT(GreaterOrEqual);

      static Common::Factory<GreaterOrEqual> RegisteredFactory("GreaterOrEqual");

      /* Default constructor */
      GreaterOrEqual::GreaterOrEqual()
	: ComparisonOperatorImplementation()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* String converter */
      String GreaterOrEqual::__repr__() const {
	return OSS() << "class=" << GreaterOrEqual::GetClassName()
		     << " name=" << getName();
      }
  

      /* Here is the interface that all derived class must implement */

      /* Virtual constructor */
      GreaterOrEqual * GreaterOrEqual::clone() const
      {
	return new GreaterOrEqual(*this);
      }

      /* Return true if comparison succeeds */
      Bool GreaterOrEqual::operator() (NumericalScalar a, NumericalScalar b) const
      {
	return (a >= b);
      }

      /* Method save() stores the object through the StorageManager */
      void GreaterOrEqual::save(const StorageManager::Advocate & adv) const
      {
	ComparisonOperatorImplementation::save(adv);
      }


      /* Method load() reloads the object from the StorageManager */
      void GreaterOrEqual::load(const StorageManager::Advocate & adv)
      {
	ComparisonOperatorImplementation::load(adv);
      }





    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
