//                                               -*- C++ -*-
/**
 *  @file  ComputedNumericalMathHessianImplementationFactory.hxx
 *  @brief The class ComputedNumericalMathHessianImplementationFactory creates ComputedNumericalMathHessianImplementation from external codes
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: ComputedNumericalMathHessianImplementationFactory.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_COMPUTEDNUMERICALMATHHESSIANIMPLEMENTATIONFACTORY_HXX
#define OPENTURNS_COMPUTEDNUMERICALMATHHESSIANIMPLEMENTATIONFACTORY_HXX

#include <iostream>              // for std::ostream
#include "OTprivate.hxx"
#include "Pointer.hxx"
#include "Exception.hxx"
#include "ComputedNumericalMathHessianImplementation.hxx"
#include "NumericalMathHessianImplementationFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class ComputedNumericalMathHessianImplementationFactory
       *
       * ComputedNumericalMathHessianImplementationFactory creates ComputedNumericalMathHessianImplementation from external codes
       */

      class ComputedNumericalMathHessianImplementationFactory
	: public NumericalMathHessianImplementationFactory
      {
	CLASSNAME;
      public:

	/* Some typedefs to ease reading */
	typedef Common::Pointer<ComputedNumericalMathHessianImplementationFactory> Instance;
	typedef NumericalMathHessianImplementationFactory::Implementation Implementation;
	typedef Common::InvalidArgumentException InvalidArgumentException;

	/** The accessor to the Singleton element */
	static Instance getInstance();



      public:

	/** String converter */
	virtual String __repr__() const;


	/** Object builder */
	virtual NumericalMathHessianImplementation * buildObject(const String & functionName) const;


      protected:

      private:

	/** The unique instance of the Singleton model */
	static Instance P_instance_;

	/** Default constructor */
	ComputedNumericalMathHessianImplementationFactory();



      }

      ; /* class ComputedNumericalMathHessianImplementationFactory */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_COMPUTEDNUMERICALMATHHESSIANIMPLEMENTATIONFACTORY_HXX */
