//                                               -*- C++ -*-
/**
 * @file  IndicatorNumericalMathEvaluationImplementation.hxx
 * @brief The class that implements the composition between numerical
 *        math functions implementations
 *
 * (C) Copyright 2005-2006 EADS
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: lebrun $
 * \date   $LastChangedDate: 2008-07-03 08:31:34 +0200 (jeu, 03 jui 2008) $
 */

#ifndef OPENTURNS_INDICATORNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX
#define OPENTURNS_INDICATORNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX

#include "NumericalMathEvaluationImplementation.hxx"
#include "ComparisonOperator.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class IndicatorNumericalMathEvaluationImplementation
       *
       * The class that implement the composition of two numerical math functions implementations.
       */
      class IndicatorNumericalMathEvaluationImplementation 
	: public NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	/* Some typedefs for easy reading */
	typedef Common::Pointer<NumericalMathEvaluationImplementation>           EvaluationImplementation;
	typedef NumericalMathEvaluationImplementation::NumericalPoint            NumericalPoint;
	typedef NumericalMathEvaluationImplementation::InvalidArgumentException  InvalidArgumentException;
	typedef NumericalMathEvaluationImplementation::InternalException         InternalException;
	typedef NumericalMathEvaluationImplementation::StorageManager            StorageManager;
	typedef Common::ComparisonOperator                                       ComparisonOperator;

	/** Default constructor */
	IndicatorNumericalMathEvaluationImplementation();

	/** Default constructor */
	IndicatorNumericalMathEvaluationImplementation(const EvaluationImplementation & p_evaluation,
						       const ComparisonOperator & comparisonOperator,
						       const NumericalScalar threshold)
	  throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual IndicatorNumericalMathEvaluationImplementation * clone() const;

	/** Comparison operator */
	Bool operator ==(const IndicatorNumericalMathEvaluationImplementation & other) const;

	/** String converter */
	virtual String __repr__() const;

	/** Operator () */
	using NumericalMathEvaluationImplementation::operator();
	NumericalPoint operator() (const NumericalPoint & in) const
	  throw(InvalidArgumentException, InternalException);

	/** Accessor for the underlying evaluation */
	EvaluationImplementation getEvaluationImplementation() const;
	void setEvaluationImplementation(const EvaluationImplementation & p_evaluation);

	/** Accessor for the comparison operator */
	ComparisonOperator getComparisonOperator() const;
	void setComparisonOperator(const ComparisonOperator & comparisonOperator);

	/** Accessor for the threshold */
	NumericalScalar getThreshold() const;
	void setThreshold(const NumericalScalar threshold);

	/** Accessor for input point dimension */
	UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	//	void load(const StorageManager::Advocate & adv);

      private:

	EvaluationImplementation p_evaluation_;
	ComparisonOperator comparisonOperator_;
	NumericalScalar threshold_;

      }; /* class IndicatorNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_INDICATORNUMERICALMATHFUNCTIONIMPLEMENTATION_HXX */
