//                                               -*- C++ -*-
/**
 *  @file  AbdoRackwitzSpecificParameters.cxx
 *  @brief SpecificParameters is an encapsulation of the AbdoRackwitz specific
 *         parameters.
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: AbdoRackwitzSpecificParameters.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <cstdlib>

#include "AbdoRackwitz.hxx"
#include "ResourceMap.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(AbdoRackwitz::SpecificParameters);

      typedef Common::ResourceMap ResourceMap;

      /* Multiplicative decrease of linear step */
      const NumericalScalar AbdoRackwitz::SpecificParameters::DefaultTau    = 0.5;//strtod(ResourceMap::GetInstance().get("AbdoRackwitz-DefaultTau").c_str(), NULL);
      /* Armijo factor */
      const NumericalScalar AbdoRackwitz::SpecificParameters::DefaultOmega  = 1.0e-4;//strtod(ResourceMap::GetInstance().get("AbdoRackwitz-DefaultOmega").c_str(), NULL);
      /* Growing factor in penalization term */
      const NumericalScalar AbdoRackwitz::SpecificParameters::DefaultSmooth = 1.2;//strtod(ResourceMap::GetInstance().get("AbdoRackwitz-DefaultSmooth").c_str(), NULL);

      /* Default onstructor */
      AbdoRackwitz::SpecificParameters::SpecificParameters():
	PersistentObject(),
	tau_(AbdoRackwitz::SpecificParameters::DefaultTau),
	omega_(AbdoRackwitz::SpecificParameters::DefaultOmega),
	smooth_(AbdoRackwitz::SpecificParameters::DefaultSmooth)
      {
	// Nothing to do
      } /* SpecificParametersAbdoRackwitz */

      /* Constructor with parameters */
      AbdoRackwitz::SpecificParameters::SpecificParameters(const NumericalScalar tau,
							   const NumericalScalar omega,
							   const NumericalScalar smooth):
	PersistentObject(),
	tau_(tau),
	omega_(omega),
	smooth_(smooth)
      {
	// Nothing to do
      } /* SpecificParametersAbdoRackwitz */

      /* Virtual constructor */
      AbdoRackwitz::SpecificParameters * AbdoRackwitz::SpecificParameters::clone() const
      {
	return new SpecificParameters(*this);
      }

      /* Tau accessor */
      NumericalScalar AbdoRackwitz::SpecificParameters::getTau() const
      {
	return tau_;
      }

      /* Tau accessor */
      void AbdoRackwitz::SpecificParameters::setTau(const NumericalScalar tau)
      {
        tau_ = tau;
      }

      /* Omega accessor */
      NumericalScalar AbdoRackwitz::SpecificParameters::getOmega() const
      {
	return omega_;
      }

      /* Omega accessor */
      void AbdoRackwitz::SpecificParameters::setOmega(const NumericalScalar omega)
      {
        omega_ = omega;
      }

      /* Smooth accessor */
      NumericalScalar AbdoRackwitz::SpecificParameters::getSmooth() const
      {
	return smooth_;
      }

      /* Smooth accessor */
      void AbdoRackwitz::SpecificParameters::setSmooth(const NumericalScalar smooth)
      {
        smooth_ = smooth;
      }

      /* String converter */
      String AbdoRackwitz::SpecificParameters::__repr__() const
      {
	OSS oss;
	oss << "class=" << AbdoRackwitz::SpecificParameters::GetClassName()
            << " tau=" << tau_
            << " omega=" << omega_
            << " smooth=" << smooth_;
	return oss;
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */



