//                                               -*- C++ -*-
/**
 *  @file  ConfidenceInterval.hxx
 *  @brief ConfidenceInterval implements the notion of confidence interval
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: ConfidenceInterval.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_CONFIDENCEINTERVAL_HXX
#define OPENTURNS_CONFIDENCEINTERVAL_HXX

#include "PersistentObject.hxx"
#include "Description.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class ConfidenceInterval
       *
       * ConfidenceInterval implements the notion of confidence interval
       */

      class ConfidenceInterval :
	public Common::PersistentObject
      {
	CLASSNAME;

      public:
        
	typedef Type::Description                Description;
	typedef Common::InvalidArgumentException InvalidArgumentException;
	typedef Common::StorageManager           StorageManager;

	/** Default constructor */
	ConfidenceInterval(const NumericalScalar firstPt = 0.0,
			   const NumericalScalar lastPt = 1.0)
	  throw(InvalidArgumentException);

	/** Virtual constructor */
	virtual ConfidenceInterval * clone() const;

	/** Description Accessor */
	void setDescription(const Description & description);
	Description getDescription() const;

	/** String converter */
	virtual String __repr__() const;
	
	/** Elements accessors */
	void setValues(const NumericalScalar firstPt,
		       const NumericalScalar lastPt) throw(InvalidArgumentException);
	const NumericalScalar & getFirst() const;
	const NumericalScalar & getLast() const;

 	/** Method save() stores the object through the StorageManager */
	void save(const StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(const StorageManager::Advocate & adv);


	/** Comparison operator */
	Bool operator ==(const ConfidenceInterval & rhs) const;

      protected:

        NumericalScalar first_ ;
	NumericalScalar last_ ;
      

      private:

	/** The description of all components */
	Description description_;

      }; /* class ConfidenceInterval */


    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_CONFIDENCEINTERVAL_HXX */
