//                                               -*- C++ -*-
/**
 * @file  SensitivityAnalysis.hxx
 * @brief SensitivityAnalysis implements the sensitivity analysis methods based on Sobol coefficients
 *
 * (C) Copyright 2005-2006 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * @author $LastChangedBy:  $
 * @date   $LastChangedDate:  $
 */

#ifndef OPENTURNS_SENSITIVITYANALYSIS_HXX
#define OPENTURNS_SENSITIVITYANALYSIS_HXX

#include "OTprivate.hxx"
#include "NumericalSample.hxx"
#include "NumericalMathFunction.hxx"
#include "NumericalPoint.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {

      /**
       * @class SensitivityAnalysis
       *
       */

      class SensitivityAnalysis
      {
      public:

	typedef Base::Func::NumericalMathFunction NumericalMathFunction;
	typedef Base::Type::NumericalPoint        NumericalPoint;
	
	static const UnsignedLong DefaultSampleSize;
	
	/** Constructor with input samples and model */
	SensitivityAnalysis(const NumericalSample & inputSample1,
			    const NumericalSample & inputSample2,
			    const NumericalMathFunction & model);
	
	/** First Order indices accessor */
	NumericalPoint getFirstOrderIndices();
	
	/** Total Order indices accessor */
	NumericalPoint getTotalOrderIndices();
	
	
	
      private:

	/** Compute all the Sobol indices */
	void computeSobolIndices();
	
	/** Check if computation of the Sobol indices is possible */
	void isComputationPossible();
	
	
	NumericalSample inputSample1_;
	NumericalSample inputSample2_;
	NumericalMathFunction model_;
	NumericalSample sensitivityIndicesSobol_;
	bool isAlreadyComputed_;

      }; /* class SensitivityAnalysis */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */
#endif /* OPENTURNS_SENSITIVITYANALYSIS_HXX */
