//                                               -*- C++ -*-
/**
 *  @file  DescriptionImplementation.cxx
 *  @brief DescriptionImplementation is the active part of Description
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: DescriptionImplementation.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include "DescriptionImplementation.hxx"
#include "Log.hxx"
#include "StorageManager.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      CLASSNAMEINIT(DescriptionImplementation);
      TEMPLATE_CLASSNAMEINIT(PersistentCollection<String>);

      typedef Common::Log Log;

      
      static Common::Factory<DescriptionImplementation> RegisteredFactory1("DescriptionImplementation");
      static Common::Factory<PersistentCollection<String> > RegisteredFactory2("PersistentCollection<String>");

      /* Default constructor */
      DescriptionImplementation::DescriptionImplementation()
	: PersistentCollection<String>()
      {
	// Nothing to do
      }


      /* Constructor with size */
      DescriptionImplementation::DescriptionImplementation(const UnsignedLong size)
	: PersistentCollection<String>(size)
      {
	// Nothing to do
      }


      /* Constructor with size */
      DescriptionImplementation::DescriptionImplementation(const String & value)
	: PersistentCollection<String>(1, value)
      {
	// Nothing to do
      }


      /* Constructor with size and default value */
      DescriptionImplementation::DescriptionImplementation(const UnsignedLong size,
							   const String & value)
	: PersistentCollection<String>(size, value)
      {
	// Nothing to do
      }


      /* Virtual constructor */
      DescriptionImplementation * DescriptionImplementation::clone() const
      {
	return new DescriptionImplementation(*this);
      }



      /* String converter */
      String DescriptionImplementation::__repr__() const
      {
	OSS oss;
	oss << "[";

	if (!isEmpty()) {
	  String separator = "";
	  for(UnsignedLong i=0; i<getSize(); i++, separator=",")
	    oss << separator << (*this)[i];
	}

	oss << "]";
	
	return oss;
      }
 
      String DescriptionImplementation::__str__() const
      {
	return __repr__();
      }

      /* Method save() stores the object through the StorageManager */
      void DescriptionImplementation::save(const StorageManager::Advocate & adv) const
      {
	PersistentCollection<String>::save(adv);
      }


      /* Method load() reloads the object from the StorageManager */
      void DescriptionImplementation::load(const StorageManager::Advocate & adv)
      {
	PersistentCollection<String>::load(adv);
      }



    } /* namespace Type */
  } /* namespace Base */
} /* namespace OpenTURNS */
