//                                               -*- C++ -*-
/**
 *  @file  NatafEllipticalCopulaGradient.hxx
 *  @brief Class for the Nataf transformation evaluation for elliptical
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: NatafEllipticalCopulaGradient.hxx 1262 2009-05-28 12:47:53Z dutka $
 */
#ifndef OPENTURNS_NATAFELLIPTICALCOPULAGRADIENT_HXX
#define OPENTURNS_NATAFELLIPTICALCOPULAGRADIENT_HXX

#include "OTprivate.hxx"
#include "NumericalMathGradientImplementation.hxx"
#include "Matrix.hxx"
#include "SquareMatrix.hxx"
#include "NumericalPoint.hxx"
#include "Distribution.hxx"
#include "Exception.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /**
       * @class NatafEllipticalCopulaGradient
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */
      class NatafEllipticalCopulaGradient
	: public Base::Func::NumericalMathGradientImplementation
      {
	CLASSNAME;
      public:

	typedef Base::Func::NumericalMathGradientImplementation NumericalMathGradientImplementation;
	typedef Base::Type::Matrix                              Matrix;
	typedef Base::Type::SquareMatrix                        SquareMatrix;
	typedef Base::Type::NumericalPoint                      NumericalPoint;
	typedef Model::Distribution                             Distribution;
	typedef Base::Common::InternalException                 InternalException;
	typedef Base::Common::InvalidArgumentException          InvalidArgumentException;

	/** Parameter constructor */
	NatafEllipticalCopulaGradient(const Distribution & standardDistribution,
				      const SquareMatrix & inverseCholesky);


	/** Virtual constructor */
	virtual NatafEllipticalCopulaGradient * clone() const;

	/** Gradient */
	Matrix gradient(const NumericalPoint & in) const
	  throw(InvalidArgumentException, InternalException);

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputNumericalPointDimension() const
	  throw(InternalException);

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputNumericalPointDimension() const
	  throw(InternalException);

	/** String converter */
	virtual String __repr__() const;

      protected:

    
      private:
	Distribution standardDistribution_;
	Matrix inverseCholesky_;

      }; /* NatafEllipticalCopulaGradient */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NATAFELLIPTICALCOPULAGRADIENT_HXX */
