//                                               -*- C++ -*-
/**
 *  @file  GumbelCopulaFactory.cxx
 *  @brief Factory for GumbelCopula distribution
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-10 16:43:31 +0200 (jeu, 10 mai 2007) $
 *  Id:      $Id: GumbelCopulaFactory.cxx 434 2007-05-10 14:43:31Z dutka $
 */
#include <cmath>
#include "GumbelCopulaFactory.hxx"
#include "GumbelCopula.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /* Default constructor */
      GumbelCopulaFactory::GumbelCopulaFactory()
      {
	// Initialize any other class members here
	// At last, allocate memory space if needed, but go to destructor to free it
      }

      /* Virtual constructor */
      GumbelCopulaFactory * GumbelCopulaFactory::clone() const
      {
	return new GumbelCopulaFactory(*this);
      }

      /* Here is the interface that all derived class must implement */

      GumbelCopulaFactory::DistributionImplementation * GumbelCopulaFactory::buildImplementation(const NumericalSample & sample) const throw(InvalidArgumentException, InternalException)
      {
	if (sample.getSize() == 0) throw InvalidArgumentException(HERE) << "Error: cannot build a GumbelCopula distribution from an empty sample";
	if (sample.getDimension() != 2) throw InvalidArgumentException(HERE) << "Error: cannot build a GumbelCopula distribution from a sample of dimension not equal to 2";
	NumericalScalar tau(sample.computeKendallTau().operator()(0, 1));
	if (tau == 1) throw InvalidArgumentException(HERE) << "Error: cannot build a GumbelCopula distribution from a sample with Kendall tau equals to 1";
	return GumbelCopula(1.0 / (1.0 - tau)).clone();
      }

      GumbelCopulaFactory::DistributionImplementation * GumbelCopulaFactory::buildImplementation(const NumericalPointCollection & parameters) const throw(InvalidArgumentException, InternalException)
      {
	try {
	  GumbelCopula distribution;
	  distribution.setParametersCollection(parameters);
	  return distribution.clone();
	}
	catch (InvalidArgumentException & ex)
	  {
	    throw InternalException(HERE) << "Error: cannot build a GumbelCopula distribution from the given parameters";
	  }
      }

      GumbelCopulaFactory::DistributionImplementation * GumbelCopulaFactory::buildImplementation() const throw(InvalidArgumentException, InternalException)
      {
	return GumbelCopula().clone();
      }


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
