//                                               -*- C++ -*-
/**
 *  @file  t_IdentityMatrix_std.cxx
 *  @brief The test file for the IdentityMatrix class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_IdentityMatrix_std.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include <cmath>
#include "NumericalPoint.hxx"
#include "IdentityMatrix.hxx"
#include "SquareMatrix.hxx"
#include "Collection.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  
  IdentityMatrix matrix1(2);
  matrix1.setName("matrix1");
  fullprint << "matrix1 = " << matrix1 << std::endl;
  
  NumericalPoint pt ;
  pt.add(5.) ;
  pt.add(0.) ;
  fullprint << "pt = " << pt << std::endl;
  
  NumericalPoint result ;
  result = matrix1.solveLinearSystem(pt);
  fullprint << "result = " << result << std::endl;
  
  NumericalScalar determinant ;
  determinant = matrix1.computeDeterminant();
  fullprint << "determinant = " << determinant << std::endl;
  
  Collection<NumericalScalar> ev(2);
  ev = matrix1.computeEigenValues().getCollection();
  fullprint << "ev = " << ev << std::endl;
  
  bool isSPD = matrix1.isPositiveDefinite();
  fullprint << "isSPD = " << isSPD << std::endl;
  
  SquareMatrix matrix2 = matrix1.computeCholesky();
  fullprint << "matrix2 = " << matrix2 << std::endl;

  return ExitCode::Success;
}
