//                                               -*- C++ -*-
/**
 *  @file  t_NumericalPoint_description.cxx
 *  @brief The test file of class NumericalPoint for standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_NumericalPoint_description.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalPointWithDescription.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  /* Constructor with size */
  NumericalPointWithDescription point1(2);
  point1[0] = 100.;
  point1[1] = 101.;

  /* Copy constructor */
  NumericalPointWithDescription point2(point1);


  {
    /* Description */
    fullprint << "point1.getDescription() = "
	      << point1.getDescription()
	      << std::endl;

    fullprint << "point2.getDescription() = "
	      << point2.getDescription()
	      << std::endl;
  }



  Description description(2);
  description[0] = "point1_X";
  description[1] = "point1_Y";

  point1.setDescription(description);


  {
    fullprint << "point1.getDescription() = "
	      << point1.getDescription()
	      << std::endl;

    fullprint << "point2.getDescription() = "
	      << point2.getDescription()
	      << std::endl;
  }



  return ExitCode::Success;
}
