//                                               -*- C++ -*-
/**
 *  @file  t_QuadraticCumul_importanceFactors.cxx
 *  @brief The test file of class QuadraticCumul for the standard methods
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_QuadraticCumul_importanceFactors.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "NumericalMathFunction.hxx"
#include "QuadraticCumul.hxx"
#include "CorrelationMatrix.hxx"
#include "Normal.hxx"
#include "NumericalPoint.hxx"
#include "RandomVector.hxx"
#include "Exception.hxx"
#include "Graph.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Stat;
using namespace OT::Base::Graph;
using namespace OT::Uncertainty::Algorithm;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {


    /* We create a NumericalMathFunction */
    NumericalMathFunction myFunc("TestQuadraticCumul");
    /* We create a distribution */
    UnsignedLong dim(myFunc.getInputNumericalPointDimension());
    NumericalPoint meanPoint(dim, 0.1);
    NumericalPoint sigma(dim, 1.0e-1);
    sigma[0] = 2.0e-1;
    sigma[1] = 3.0e-1;
    CorrelationMatrix R(dim);
    for (UnsignedLong i = 0; i < dim; i++)
      {
	R(i, i) = 1.0;
      }
    for (UnsignedLong i = 1; i < dim; i++)
      {
	R(i, i - 1) = 0.25;
      }
    Normal myDistribution(meanPoint, sigma, R);

    /* we name the components of the distribution */
    Description componentDescription(dim);
    componentDescription[0] = "Marginal 1";
    componentDescription[1] = "Marginal 2";
    myDistribution.setDescription(componentDescription);

    /* We create a distribution-based RandomVector */
    RandomVector X(myDistribution);

    /* We create a composite RandomVector Y from X and myFunction */
    RandomVector Y(myFunc, X);
    Y.setName("Interest Variable 1");

    // We create a quadraticCumul algorithm
    QuadraticCumul myQuadraticCumul(Y);
    // We test the attributs here
    fullprint << "Importance factors=" << myQuadraticCumul.getImportanceFactors() << std::endl;

    Graph importanceFactorsGraph(myQuadraticCumul.drawImportanceFactors());
    importanceFactorsGraph.draw("ImportanceFactorsDrawingQuadraticCumul", 640, 480);

    // Check that the correct files have been generated by computing their checksum
    fullprint << "bitmap=" << importanceFactorsGraph.getBitmap() << std::endl;
    fullprint << "postscript=" << importanceFactorsGraph.getPostscript() << std::endl;
  }

  catch (OT::Base::Common::NotSymmetricDefinitePositiveException & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }
  
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
