//                                               -*- C++ -*-
/**
 *  @file  t_RandomVector_distribution.cxx
 *  @brief The test file of distribution-based RandomVector class
 *
 *  (C) Copyright 2005-2007 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2009-05-28 14:47:53 +0200 (jeu. 28 mai 2009) $
 *  Id:      $Id: t_RandomVector_distribution.cxx 1262 2009-05-28 12:47:53Z dutka $
 */
#include <iostream>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "RandomVector.hxx"
#include "Normal.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Stat;
using namespace OT::Uncertainty::Model;
using namespace OT::Uncertainty::Distribution;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);
  setRandomGenerator();

  try {

    /* We create a distribution */
    NumericalPoint meanPoint(1);
    meanPoint[0] = 1.0;
    NumericalPoint sigma(1);
    sigma[0] = 1.0;
    CorrelationMatrix R(1);
    R(0, 0) = 1.0;
    Normal distribution(meanPoint, sigma, R);

    const Normal & ref_distribution(distribution);

    fullprint << "distribution = " << ref_distribution << std::endl;



    /* We create a distribution-based RandomVector */
    RandomVector vect(distribution);
    fullprint << "vect=" << vect << std::endl;

    /* Check standard methods of class RandomVector */
    fullprint << "vect dimension=" << vect.getDimension() << std::endl;
    fullprint << "vect realization (first )=" << vect.getRealization() << std::endl;
    fullprint << "vect realization (second)=" << vect.getRealization() << std::endl;
    fullprint << "vect realization (third )=" << vect.getRealization() << std::endl;
    fullprint << "vect sample =" << vect.getNumericalSample(5) << std::endl;


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
