// SWIG file NumericalMathFunction.i
// Author : $LastChangedBy: dutka $
// Date : $LastChangedDate: 2008-10-15 17:56:07 +0200 (mer. 15 oct. 2008) $
// Id : $Id: NumericalMathFunction.i 972 2008-10-15 15:56:07Z dutka $

%{
#include "NumericalMathFunction.hxx"
#include "PythonNumericalMathEvaluationImplementation.hxx"
%}

%pythoncode %{

class OpenTURNSPythonFunction :

  def __init__(self, n=0, p=0) :
    self.n = n
    self.p = p
    pass

  def getInputNumericalPointDimension(self) :
    return self.n

  def getOutputNumericalPointDimension(self) :
    return self.p

  def __call__(self, X) :
    Y = None
    import types
    if ( type(X) not in (types.TupleType, types.ListType) ): 
      raise TypeError("Expect sequence argument like a list or a tuple")
    if (len(X) != self.n): 
      raise TypeError("Expect sequence argument of length %d. Got %d" % (self.n, len(X)) )

    Y = self.f(X)

    if ( type(Y) not in (types.TupleType, types.ListType) ): 
      raise TypeError("Expect sequence argument like a list or a tuple as f's return value. Check f method")
    if (len(Y) != self.p): 
      raise TypeError("Expect sequence argument of length %d. Got %d. Check f method" % (self.p, len(Y)) )

    return Y

  def f(self, X) :
    return X

%}

%template(NumericalMathFunctionImplementationTypedInterfaceObject)           OpenTURNS::Base::Common::TypedInterfaceObject<OpenTURNS::Base::Func::NumericalMathFunctionImplementation>;
%include NumericalMathFunction.hxx
namespace OpenTURNS { namespace Base { namespace Func {

%extend NumericalMathFunction {

NumericalMathFunction(const NumericalMathFunction & other)
{ return new OpenTURNS::Base::Func::NumericalMathFunction(other); }

NumericalMathFunction(PyObject * pyObj)
{
 if (!PyCallable_Check( pyObj )) {
   throw OT::Base::Common::InvalidArgumentException(HERE) << "Argument is not a callable object (function or class)";
 }

 return new OpenTURNS::Base::Func::NumericalMathFunction(new OpenTURNS::Base::Func::NumericalMathFunctionImplementation(new OpenTURNS::Base::Func::PythonNumericalMathEvaluationImplementation(pyObj) ) );
}

}

}}}
