#! /usr/bin/env python

from openturns import *

TESTPREAMBLE()

try :
  #We create an empty NumericalSample
  sample1 = NumericalSample(0, 2)
  sample1.setName("Sample1")

  #We populate the empty sample
  point1 = NumericalPoint(2)
  point1[0] = 10.
  point1[1] = 20.
  point2 = NumericalPoint(2)
  point2[0] = 11.
  point2[1] = 21.
  point3 = NumericalPoint(2)
  point3[0] = 12.
  point3[1] = 22.
  sample1.add(point1)
  sample1.add(point2)
  sample1.add(point3)
  print "sample1=", sample1

  #We get the second element of the sample
  secondElement = sample1[1]
  print "second element=", repr(secondElement) 

  #We set the third element to a valid new element
  newPoint = NumericalPoint(2)
  newPoint[0] = 1000
  newPoint[1] = 2000
  sample1[2] = newPoint
  print "sample1=",sample1 

  sample2 = NumericalSample(10, point1)
  print "sample2=", sample2 

  sample2[5] = point2
  print "sample2=", sample2

  try :
    #We get the tenth element of the sample
    #THIS SHOULD NORMALLY FAIL
    tenthElement = sample1[9]

    #Normally, we should never go here
    raise
  except :
    pass

  #We try to create a sample with 5 times the same point
  samePoint = NumericalPoint(3)
  samePoint[0] = 1000.
  samePoint[1] = 2000.
  samePoint[2] = 3000.
  sample3 = NumericalSample(5, samePoint)
  print "sample3=" , sample3 

  #We append a new point to the sample...
  anotherNewPoint = NumericalPoint(3)
  anotherNewPoint[0] = -1000.
  anotherNewPoint[1] = -2000.
  anotherNewPoint[2] = -3000.
  sample3.add(anotherNewPoint)
  print "sample3=" , sample3


  #... then the first point again
  sample3.add(samePoint)
  print "sample3=", sample3 

  #We find the new point into the sample
  pos = sample3.find(anotherNewPoint)
  if (pos != 5) :
    print "Error in finding point into sample. Expected 5. Got " , pos

  #We erase the new point from the sample
  sample3.erase(pos)
  print "sample3=" , sample3

except :
  import sys
  print "t_NumericalSample_std.py", sys.exc_type, sys.exc_value

