#!/bin/sh

# Transform tests files for win32 platform or restore them for unix like.

# This script can be called twice with the same arg without making troubles to the files.
# This script is not reentrant !
# Every .xml .at files in the checktest source directory are modified ! 

usage()
{
  echo "usage: ./adapt_check_tests.sh win32|unix [check_test_path]"
  exit 1
}

if [ "$#" -eq "1" ]; then 
  TARGET_PLATEFORM="$1" 
  CHECK_TEST_PATH="../lib/test"
  # to determine automatically CHECK_TEST_PATH, adapt_check_tests.sh must be called from where it resides
  if [ "$0" != "./adapt_check_tests.sh" ]; then
    usage
  fi
elif [ "$#" -eq "2" ]; then 
  TARGET_PLATEFORM="$1" 
  CHECK_TEST_PATH="$2"
else
  usage 
fi 

echo "Modifiying checktest files for $TARGET_PLATEFORM in directory $CHECK_TEST_PATH."

LINUX_PROG_CHECK="\(AT_CHECK[([ ]*\)\(t_[a-zA-Z1-9_]*\)\([] ]*,[ ]*\)"
WIN32_PROG_CHECK='\(AT_CHECK[([ ]*\)\(t_[a-zA-Z1-9_]*\)\(\.exe\)\([] ,]*\)'
WIN32_SUFFIX='.exe'

adapt_check_tests_for_win32()
{
  # add WIN32_SUFFIX
  sed -i -e "s/^[ ]*$LINUX_PROG_CHECK/\1\2$WIN32_SUFFIX\3/" $CHECK_TEST_PATH/*.at

  # transform .so to -0.dll
  sed -i -e 's/[.]so\([<"]\)/-0.dll\1/g' $CHECK_TEST_PATH/*.xml

  # call batch external code instead of shell external code
  sed -i -e "s/\(poutre_files\)\.sh/\1.bat/" $CHECK_TEST_PATH/poutre_external.xml
}

restore_check_tests()
{
  # delete WIN32_SUFFIX
  sed -i -e "s/^[ ]*$WIN32_PROG_CHECK/\1\2\4/" $CHECK_TEST_PATH/*.at

  # transform -0.dll to .so
  sed -i -e "s/-0.dll/.so/g" $CHECK_TEST_PATH/*.xml

  # call shell external code instead of batch external code
  sed -i -e "s/\(poutre_files\)\.bat/\1.sh/" $CHECK_TEST_PATH/poutre_external.xml
}

case $TARGET_PLATEFORM in
  win32)
    adapt_check_tests_for_win32
    ;;
  unix)
    restore_check_tests
    ;;
  *)
    usage
    ;;
esac

exit 0


