//                                               -*- C++ -*-
/**
 *  @file  LessOrEqual.cxx
 *  @brief Abstract top-level class for all LessOrEqual
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: LessOrEqual.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "LessOrEqual.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Common {

      CLASSNAMEINIT(LessOrEqual);

      static Common::Factory<LessOrEqual> RegisteredFactory("LessOrEqual");

      /* Default constructor */
      LessOrEqual::LessOrEqual()
	: ComparisonOperatorImplementation()
      {
	// Nothing to do
      }

      /* String converter */
      String LessOrEqual::__repr__() const {
	return OSS() << "class=" << LessOrEqual::GetClassName()
		     << " name=" << getName();
      }
  

      /* Here is the interface that all derived class must implement */

      /* Virtual constructor */
      LessOrEqual * LessOrEqual::clone() const
      {
	return new LessOrEqual(*this);
      }

      /* Return true if comparison succeeds */
      Bool LessOrEqual::operator() (NumericalScalar a, NumericalScalar b) const
      {
	return (a <= b);
      }

      /* Method save() stores the object through the StorageManager */
      void LessOrEqual::save(StorageManager::Advocate & adv) const
      {
	ComparisonOperatorImplementation::save(adv);
      }


      /* Method load() reloads the object from the StorageManager */
      void LessOrEqual::load(StorageManager::Advocate & adv)
      {
	ComparisonOperatorImplementation::load(adv);
      }





    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */
