//                                               -*- C++ -*-
/**
 *  @file  ProductPolynomialEvaluationImplementation.hxx
 *  @brief This is a nD polynomial build as a product of n 1D polynomial
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_PRODUCTPOLYNOMIALEVALUATIONIMPLEMENTATION_HXX
#define OPENTURNS_PRODUCTPOLYNOMIALEVALUATIONIMPLEMENTATION_HXX

#include "NumericalMathEvaluationImplementation.hxx"
#include "UniVariatePolynomial.hxx"
#include "PersistentCollection.hxx"
#include "NumericalPoint.hxx"
#include "Exception.hxx"



namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class ProductPolynomialEvaluationImplementation
       *
       * This is a nD polynomial build as a product of n 1D polynomial
       */

      class ProductPolynomialEvaluationImplementation
	: public NumericalMathEvaluationImplementation
      {
	CLASSNAME;
      public:

	typedef Common::StorageManager                           StorageManager;
	typedef Common::InvalidArgumentException                 InvalidArgumentException;
	typedef Common::InternalException                        InternalException;
	typedef Type::NumericalPoint                             NumericalPoint;
	typedef Type::Collection<UniVariatePolynomial>           PolynomialCollection;
	typedef Type::PersistentCollection<UniVariatePolynomial> PolynomialPersistentCollection;

	/** Constructor */
	ProductPolynomialEvaluationImplementation(const PolynomialCollection & coll);

	/** Virtual constructor */
	ProductPolynomialEvaluationImplementation * clone() const;

	/** String converter */
	virtual String __repr__() const;

	/** Operator () */
	virtual NumericalPoint operator() (const NumericalPoint & in) const
	  /* throw(InvalidArgumentException, InternalException) */;

	/** Accessor for input point dimension */
	virtual UnsignedLong getInputDimension() const
	  /* throw(InternalException) */;

	/** Accessor for output point dimension */
	virtual UnsignedLong getOutputDimension() const
	  /* throw(InternalException) */;

 	/** Method save() stores the object through the StorageManager */
	void save(StorageManager::Advocate & adv) const;

	/** Method load() reloads the object from the StorageManager */
	void load(StorageManager::Advocate & adv);



      protected:

	friend class Common::Factory<ProductPolynomialEvaluationImplementation>;

	/* Default constructor */
	ProductPolynomialEvaluationImplementation();

      private:

	/** The set of 1d polynomials to build the nD polynomial */
	PolynomialPersistentCollection polynomials_;

      } ; /* class ProductPolynomialEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PRODUCTPOLYNOMIALEVALUATIONIMPLEMENTATION_HXX */
