//                                               -*- C++ -*-
/**
 *  @file  UniVariatePolynomial.cxx
 *  @brief This is a 1D polynomial
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 11:21:38 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.cxx 815 2008-05-21 09:21:38Z dutka $
 */
#include "UniVariatePolynomial.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      CLASSNAMEINIT(UniVariatePolynomial);

      /* Default constructor */
      UniVariatePolynomial::UniVariatePolynomial()
        : Base::Common::TypedInterfaceObject<UniVariatePolynomialImplementation>(new UniVariatePolynomialImplementation())
      {
        // Nothing to do
      }


      /* Constructor from coefficients */
      UniVariatePolynomial::UniVariatePolynomial(const Coefficients & coefficients)
        : Base::Common::TypedInterfaceObject<UniVariatePolynomialImplementation>(new UniVariatePolynomialImplementation(coefficients))
      {
	// Nothing to do
      }


      /* Constructor from implementation */
      UniVariatePolynomial::UniVariatePolynomial(const UniVariatePolynomialImplementation & implementation)
        : Base::Common::TypedInterfaceObject<UniVariatePolynomialImplementation>(implementation.clone())
      {
	// Nothing to do
      }


      /* Constructor from implementation pointer */
      UniVariatePolynomial::UniVariatePolynomial(const Implementation & p_implementation)
        : Base::Common::TypedInterfaceObject<UniVariatePolynomialImplementation>(p_implementation)
      {
	// Nothing to do
      }


      /* Constructor from implementation pointer */
      UniVariatePolynomial::UniVariatePolynomial(UniVariatePolynomialImplementation * p_implementation)
        : Base::Common::TypedInterfaceObject<UniVariatePolynomialImplementation>(p_implementation)
      {
	// Nothing to do
	}

      /* String converter */
      String UniVariatePolynomial::__repr__() const
      {
        return OSS() << "class=" << getClassName()
                     << " coefficients=" << getImplementation()->getCoefficients().__repr__();
      }


      String UniVariatePolynomial::__str__() const
      {
        return OSS() << getImplementation()->__str__();
      }


      /* UniVariatePolynomial are evaluated as functors */
      NumericalScalar UniVariatePolynomial::operator() (const NumericalScalar x) const
      {
	return getImplementation()->operator()(x);
      }


      /* Multiply the polynomial P by a NumericalScalar */
      UniVariatePolynomial UniVariatePolynomial::operator* (const NumericalScalar scal) const
      {
	return getImplementation()->operator*(scal);
      } // end method operator*

      /* Multiply the polynomial P by an UniVariatePolynomial */
      UniVariatePolynomial UniVariatePolynomial::operator* (const UniVariatePolynomial & uniVariatePolynomial) const
      {
	return getImplementation()->operator*(*(uniVariatePolynomial.getImplementation()));
      } // end method operator*

      /* Multiply the polynomial by (x to the power deg) */
      UniVariatePolynomial UniVariatePolynomial::incrementDegree(const UnsignedLong deg) const
      {
	return getImplementation()->incrementDegree(deg);
      }// end incrementDegree


      /* Realize the summation of two polynomials of any degree ex:P=P1+P2 */
      UniVariatePolynomial UniVariatePolynomial::operator + (const UniVariatePolynomial & uniVariatePolynomial) const
      {
	return getImplementation()->operator+(*(uniVariatePolynomial.getImplementation()));
      } // end summation of P1 & P2


      /* Realize the substraction of two polynomials of any degree ex:P=P1-P2 */
      UniVariatePolynomial UniVariatePolynomial::operator - (const UniVariatePolynomial & uniVariatePolynomial) const
      {
	return getImplementation()->operator-(*(uniVariatePolynomial.getImplementation()));
      } // end substraction of P1 & P2 */

      /* Coefficients accessor */
      void UniVariatePolynomial::setCoefficients(const Coefficients & coefficients)
      {
	getImplementation()->setCoefficients(coefficients);
      }

      UniVariatePolynomial::Coefficients UniVariatePolynomial::getCoefficients() const
      {
	return getImplementation()->getCoefficients();
      }


      /* Method to draw the graph of the polynomial between given bounds */
      UniVariatePolynomial::Graph UniVariatePolynomial::draw(const NumericalScalar xMin,
							     const NumericalScalar xMax,
							     const UnsignedLong pointNumber) const
      {
	return getImplementation()->draw(xMin, xMax, pointNumber);
      }


      /* Get the degree of the polynomial */
      UnsignedLong UniVariatePolynomial::getDegree() const
      {
	return getImplementation()->getDegree();
      }


      /* Root of the polynomial */
      UniVariatePolynomial::NumericalComplexCollection UniVariatePolynomial::getRoots() const
      {
	return getImplementation()->getRoots();
      }

    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */
