//                                               -*- C++ -*-
/**
 *  @file  BoundConstrainedAlgorithm.cxx
 *  @brief BoundConstrainedAlgorithm implements an algorithm for finding the 
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: BoundConstrainedAlgorithm.cxx 1473 2010-02-04 15:44:49Z dutka $
 */
#include "BoundConstrainedAlgorithm.hxx"
#include "TNC.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      CLASSNAMEINIT(BoundConstrainedAlgorithm);

      /* Default constructor */
      BoundConstrainedAlgorithm::BoundConstrainedAlgorithm() :
	Common::TypedInterfaceObject<BoundConstrainedAlgorithmImplementation>(new BoundConstrainedAlgorithmImplementation()),
        Threadable()
      {
	// Nothing to do
      }

      /* Constructor from an implementation */
      BoundConstrainedAlgorithm::BoundConstrainedAlgorithm(const BoundConstrainedAlgorithmImplementation & implementation) :
	Common::TypedInterfaceObject<BoundConstrainedAlgorithmImplementation>(implementation.clone()),
        Threadable()
      {
	// Nothing to do
      }

      /* Constructor from a Pointer to an implementation */
      BoundConstrainedAlgorithm::BoundConstrainedAlgorithm(const Implementation & p_implementation) :
	Common::TypedInterfaceObject<BoundConstrainedAlgorithmImplementation>(p_implementation),
        Threadable()
      {
	// Nothing to do
      }

      /* Constructor with parameters: no constraint, starting from the origin */
      BoundConstrainedAlgorithm::BoundConstrainedAlgorithm(const NumericalMathFunction & objectiveFunction,
							   const Bool verbose):
	Common::TypedInterfaceObject<BoundConstrainedAlgorithmImplementation>(new TNC(objectiveFunction, verbose)),
        Threadable()
      {
	// Nothing to do
      }

      /* Constructor with parameters: bound constraints, starting from the given point */
      BoundConstrainedAlgorithm::BoundConstrainedAlgorithm(const NumericalMathFunction & objectiveFunction,
							   const Interval & boundConstraints,
							   const NumericalPoint & startingPoint,
							   const OptimizationProblem optimization,
							   const Bool verbose)
      /* throw(InvalidArgumentException) */
	: Common::TypedInterfaceObject<BoundConstrainedAlgorithmImplementation>(new TNC(TNC::SpecificParameters(), objectiveFunction, boundConstraints, startingPoint, optimization, verbose)),
	  Threadable()
      {
	// Nothing to do
      }

      /* Starting point accessor */
      BoundConstrainedAlgorithm::NumericalPoint BoundConstrainedAlgorithm::getStartingPoint() const
      {
	return getImplementation()->getStartingPoint();
      }

      void BoundConstrainedAlgorithm::setStartingPoint(const NumericalPoint & startingPoint)
      {
	getImplementation()->setStartingPoint(startingPoint);
      }

      /* Bound constraints accessor */
      BoundConstrainedAlgorithm::Interval BoundConstrainedAlgorithm::getBoundConstraints() const
      {
	return getImplementation()->getBoundConstraints();
      }

      void BoundConstrainedAlgorithm::setBoundConstraints(const Interval & boundConstraints)
      {
	getImplementation()->setBoundConstraints(boundConstraints);
      }

      /* Optimization problem accessor */
      BoundConstrainedAlgorithm::OptimizationProblem BoundConstrainedAlgorithm::getOptimizationProblem() const
      {
	return getImplementation()->getOptimizationProblem();
      }

      void BoundConstrainedAlgorithm::setOptimizationProblem(const OptimizationProblem optimization)
      {
	getImplementation()->setOptimizationProblem(optimization);
      }

      /* Result accessor */
      BoundConstrainedAlgorithm::Result BoundConstrainedAlgorithm::getResult() const
      {
	return getImplementation()->getResult();
      }

      void BoundConstrainedAlgorithm::setResult(const Result & result)
      {
	getImplementation()->setResult(result);
      }

      /* Maximum iterations number accessor */
      UnsignedLong BoundConstrainedAlgorithm::getMaximumEvaluationsNumber() const
      {
	return getImplementation()->getMaximumEvaluationsNumber();
      }

      void BoundConstrainedAlgorithm::setMaximumEvaluationsNumber(const UnsignedLong maximumEvaluationsNumber)
      {
	getImplementation()->setMaximumEvaluationsNumber(maximumEvaluationsNumber);
      }

      /* Maximum absolute error accessor */
      NumericalScalar BoundConstrainedAlgorithm::getMaximumAbsoluteError() const
      {
	return getImplementation()->getMaximumAbsoluteError();
      }

      void BoundConstrainedAlgorithm::setMaximumAbsoluteError(const NumericalScalar maximumAbsoluteError)
      {
	getImplementation()->setMaximumAbsoluteError(maximumAbsoluteError);
      }

      /* Maximum relative error accessor */
      NumericalScalar BoundConstrainedAlgorithm::getMaximumRelativeError() const
      {
	return getImplementation()->getMaximumRelativeError();
      }

      void BoundConstrainedAlgorithm::setMaximumRelativeError(const NumericalScalar maximumRelativeError)
      {
	getImplementation()->setMaximumRelativeError(maximumRelativeError);
      }

      /* Maximum objective error accessor */
      NumericalScalar BoundConstrainedAlgorithm::getMaximumObjectiveError() const
      {
	return getImplementation()->getMaximumObjectiveError();
      }

      void BoundConstrainedAlgorithm::setMaximumObjectiveError(const NumericalScalar maximumObjectiveError)
      {
	getImplementation()->setMaximumObjectiveError(maximumObjectiveError);
      }

      /* Maximum constraint error accessor */
      NumericalScalar BoundConstrainedAlgorithm::getMaximumConstraintError() const
      {
	return getImplementation()->getMaximumConstraintError();
      }

      void BoundConstrainedAlgorithm::setMaximumConstraintError(const NumericalScalar maximumConstraintError)
      {
	getImplementation()->setMaximumConstraintError(maximumConstraintError);
      }

      /* String converter */
      String BoundConstrainedAlgorithm::__repr__() const
      {
	OSS oss;
	oss << "class=" << BoundConstrainedAlgorithm::GetClassName()
            << " implementation=" << getImplementation()->__repr__();
	return oss;
      }

      /* Objective function accessor */
      BoundConstrainedAlgorithm::NumericalMathFunction BoundConstrainedAlgorithm::getObjectiveFunction() const
      {
	return getImplementation()->getObjectiveFunction();
      }

      void BoundConstrainedAlgorithm::setObjectiveFunction(const NumericalMathFunction & objectiveFunction)
      {
	getImplementation()->setObjectiveFunction(objectiveFunction);
      }

      /* Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
      void BoundConstrainedAlgorithm::run()
	/* throw(InternalException) */
      {
	getImplementation()->run();
      }

      /* Verbose accessor */
      Bool BoundConstrainedAlgorithm::getVerbose() const
      {
	return getImplementation()->getVerbose();
      }

      /* Verbose accessor */
      void BoundConstrainedAlgorithm::setVerbose(const Bool verbose)
      {
	getImplementation()->setVerbose(verbose);
      }

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */
