//                                               -*- C++ -*-
/**
 *  @file  SobolIndiceParameters.cxx
 *  @brief SobolIndiceParameters permits to choose which indices to compute
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2008-05-05 08:50:15 +0200 (lun, 05 mai 2008) $
 *  Id:      $Id: SobolIndiceParameters.cxx 805 2008-05-05 06:50:15Z schueller $
 */
#include <cstdlib>

#include "CorrelationAnalysis.hxx"

namespace OpenTURNS
{
  namespace Base
  {
    namespace Stat
    {

      CLASSNAMEINIT(CorrelationAnalysis::SobolIndiceParameters);

      typedef Common::ResourceMap ResourceMap;

      const UnsignedLong CorrelationAnalysis::SobolIndiceParameters::DefaultMaximumOrder = 0;//strtoul(ResourceMap::GetInstance().get("CorrelationAnalysis-DefaultMaximumOrder").c_str(), NULL, 0);
      const Bool CorrelationAnalysis::SobolIndiceParameters::DefaultTotalIndiceComputation = false;//(ResourceMap::GetInstance().get("CorrelationAnalysis-DefaultTotalIndiceComputation") == String("true"));

      /** default constructor */
      CorrelationAnalysis::SobolIndiceParameters::SobolIndiceParameters() :
	PersistentObject(),
	maximumOrder_(DefaultMaximumOrder),
	totalIndiceComputation_(DefaultTotalIndiceComputation)
      {
	// nothing to do
      }

      /** constructor with parameters */
      CorrelationAnalysis::SobolIndiceParameters::SobolIndiceParameters(const UnsignedLong maximumOrder,
									const Bool computeTotalIndice) :
	PersistentObject(),
	maximumOrder_(maximumOrder),
	totalIndiceComputation_(computeTotalIndice)
      {
	// nothing to do
      }


      /** Virtual constructor */
      CorrelationAnalysis::SobolIndiceParameters * CorrelationAnalysis::SobolIndiceParameters::clone() const
      {
	return new SobolIndiceParameters(*this);
      }


      /** maximum Order accessor */
      UnsignedLong CorrelationAnalysis::SobolIndiceParameters::getMaximumOrder(void) const
      {
	return maximumOrder_;
      }

      void CorrelationAnalysis::SobolIndiceParameters::setMaximumOrder(const UnsignedLong maximumOrder)
      {
	maximumOrder_ = maximumOrder;
      }


      /** total Indice accessor */
      Bool CorrelationAnalysis::SobolIndiceParameters::getTotalIndiceComputation(void) const
      {
	return totalIndiceComputation_;
      }

      void CorrelationAnalysis::SobolIndiceParameters::setTotalIndiceComputation(const Bool totalIndiceComputation)
      {
	totalIndiceComputation_ = totalIndiceComputation;
      }


      /** String converter */
      String CorrelationAnalysis::SobolIndiceParameters::__repr__() const
      {
	OSS oss;
	oss << "class=" << CorrelationAnalysis::SobolIndiceParameters::GetClassName()
	    << " maximumOrder=" << maximumOrder_
	    << " totalIndiceComputation=" << totalIndiceComputation_;
	return oss;
      }

    } // namespace Stat
  } // namespace Base
} // namespace OpenTURNS
