//                                               -*- C++ -*-
/**
 *  @file  LowDiscrepancyExperiment.hxx
 *  @brief Abstract top-level view of an monteCarloExperiment plane
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: LowDiscrepancyExperiment.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_LOWDISCREPANCYEXPERIMENT_HXX
#define OPENTURNS_LOWDISCREPANCYEXPERIMENT_HXX

#include "WeightedExperiment.hxx"
#include "LowDiscrepancySequence.hxx"
#include "Collection.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class LowDiscrepancyExperiment
       *
       * The class describes the probabilistic concept of monteCarloExperiment plan
       */
      class LowDiscrepancyExperiment
	: public WeightedExperiment
      {
	CLASSNAME;
      public:

	typedef WeightedExperiment::Distribution     Distribution;
	typedef Base::Type::Collection<Distribution> DistributionCollection;
	typedef Base::Stat::LowDiscrepancySequence   LowDiscrepancySequence;

	/** Default constructor */
	explicit LowDiscrepancyExperiment(const String & name = OT::DefaultName);
	
	/** Parameters constructor */
	explicit LowDiscrepancyExperiment(const UnsignedLong size,
					  const String & name = OT::DefaultName);
	
	/** Parameters constructor */
	explicit LowDiscrepancyExperiment(const LowDiscrepancySequence & sequence,
					  const UnsignedLong size,
					  const String & name = OT::DefaultName);
	
	/** Parameters constructor */
	explicit LowDiscrepancyExperiment(const LowDiscrepancySequence & sequence,
					  const Distribution & distribution,
					  const UnsignedLong size,
					  const String & name = OT::DefaultName);
	
	/** Virtual constructor */
	virtual LowDiscrepancyExperiment * clone() const;
	
	/** String converter */
	virtual String __repr__() const;
	
	/** Distribution accessor */
	virtual void setDistribution(const Distribution & distribution);

	/** Sequence accessor */
	LowDiscrepancySequence getSequence() const;
	
	/* Here is the interface that all derived class must implement */
	
	/** Sample generation */
	virtual NumericalSample generate();

	/** Sample generation with weights */
	NumericalSample generate(NumericalPoint & weights);

      protected:
	
      private:
	// Marginal distributions
	DistributionCollection marginals_;

	// Low discrepancy sequence
	LowDiscrepancySequence sequence_;

      }; /* class LowDiscrepancyExperiment */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_LOWDISCREPANCYEXPERIMENT_HXX */
