//                                               -*- C++ -*-
/**
 *  @file  PostAnalyticalSimulation.hxx
 *  @brief PostAnalyticalSimulation is a generic view of postAnalyticalSimulation methods for computing
 * probabilities and related quantities by sampling and estimation
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2008-05-16 12:56:34 +0200 (ven, 16 mai 2008) $
 *  Id:      $Id: PostAnalyticalSimulation.hxx 808 2008-05-16 10:56:34Z lebrun $
 */
#ifndef OPENTURNS_POSTANALYTICALSIMULATION_HXX
#define OPENTURNS_POSTANALYTICALSIMULATION_HXX

#include "Simulation.hxx"
#include "AnalyticalResult.hxx"
#include "StandardEvent.hxx"
#include "Distribution.hxx"

namespace OpenTURNS
{

  namespace Uncertainty 
  {

    namespace Algorithm
    {


      /**
       * @class PostAnalyticalSimulation
       */

      class PostAnalyticalSimulation
	: public Simulation
      {

	CLASSNAME;
      public:

	typedef Model::StandardEvent StandardEvent;
	typedef Model::Distribution  Distribution;

	/** Constructor with parameters */
	explicit PostAnalyticalSimulation(const AnalyticalResult & analyticalResult);

	/** Event accessor */
	AnalyticalResult getAnalyticalResult() const;

	/** String converter */
	String __repr__() const;

      protected:

	/** FORM result upon which one compute a correction */
	AnalyticalResult analyticalResult_;

	/** Standard event associated to analytical result */
	StandardEvent standardEvent_;

	/** Standard distribution associated to the standard event */
	Distribution standardDistribution_;

	/** Probability associated to the control */
	NumericalScalar controlProbability_;

      } ; /* class PostAnalyticalSimulation */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_POSTANALYTICALSIMULATION_HXX */
