//                                               -*- C++ -*-
/**
 *  @file  HistogramFactory.hxx
 *  @brief Factory for Histogram distribution
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: HistogramFactory.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_HISTOGRAMFACTORY_HXX
#define OPENTURNS_HISTOGRAMFACTORY_HXX

#include "OTprivate.hxx"
#include "DistributionImplementationFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Distribution {

      /**
       * @class HistogramFactory
       */
      class HistogramFactory
	: public Model::DistributionImplementationFactory
      {
      public:

	typedef Model::DistributionImplementationFactory                    DistributionImplementationFactory; // required by SWIG
	typedef DistributionImplementationFactory::NumericalSample          NumericalSample;
	typedef DistributionImplementationFactory::InternalException        InternalException;
	typedef DistributionImplementationFactory::InvalidArgumentException InvalidArgumentException;
	typedef Model::DistributionImplementation                           DistributionImplementation;

	/** Default constructor */
	HistogramFactory();

	/** Virtual constructor */
	virtual HistogramFactory * clone() const;

	/* Here is the interface that all derived class must implement */

	virtual DistributionImplementation * buildImplementation(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;
	virtual DistributionImplementation * buildImplementation() const /* throw(InvalidArgumentException, InternalException) */;

    
      }; /* class HistogramFactory */


    } /* namespace Distribution */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_HISTOGRAMFACTORY_HXX */
