//                                               -*- C++ -*-
/**
 *  @file  UsualRandomVector.hxx
 *  @brief An implementation class for distribution-based random vectors
 *
 *  (C) Copyright 2005-2010 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2010-02-04 16:44:49 +0100 (jeu. 04 févr. 2010) $
 *  Id:      $Id: UsualRandomVector.hxx 1473 2010-02-04 15:44:49Z dutka $
 */
#ifndef OPENTURNS_USUALRANDOMVECTOR_HXX
#define OPENTURNS_USUALRANDOMVECTOR_HXX

#include "OTprivate.hxx"
#include "RandomVectorImplementation.hxx"
#include "Distribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {



      /**
       * @class UsualRandomVector
       *
       * An implementation class for distribution-based random vectors
       */
      class UsualRandomVector
        : public RandomVectorImplementation
      {
        CLASSNAME;

      public:

        /** Some typedefs to ease reading */
        typedef Model::RandomVectorImplementation::Antecedent            Antecedent;
        typedef Model::RandomVectorImplementation::Implementation        Implementation;
        typedef Model::RandomVectorImplementation::Indices               Indices;
        typedef Model::RandomVectorImplementation::NumericalPoint        NumericalPoint;
        typedef Model::RandomVectorImplementation::NumericalSample       NumericalSample;
        typedef Model::RandomVectorImplementation::CovarianceMatrix      CovarianceMatrix;
        typedef Model::RandomVectorImplementation::NumericalMathFunction NumericalMathFunction;


        /** Default constructor */
        UsualRandomVector(const Distribution & distribution,
                          const String & name = OT::DefaultName);


        /** Virtual constructor */
        UsualRandomVector * clone() const;

        /** String converter */
        String __repr__() const;


        /* Here is the interface that all derived class must implement */

        /** Dimension accessor */
        UnsignedLong getDimension() const;

        /** Realization accessor */
        NumericalPoint getRealization() const;

        /** Numerical sample accessor */
        NumericalSample getNumericalSample(UnsignedLong size) const;

        /** Mean accessor */
        NumericalPoint getMean() const;

        /** Covariance accessor */
        CovarianceMatrix getCovariance() const;

        /** Get the random vector corresponding to the i-th marginal component */
        Implementation getMarginal(const UnsignedLong i) const /* throw(InvalidArgumentException) */;

        /** Get the marginal random vector corresponding to indices components */
        Implementation getMarginal(const Indices & indices) const /* throw(InvalidArgumentException) */;

        /** Distribution accessor */
        Distribution getDistribution() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:

        friend class Base::Common::Factory<UsualRandomVector>;

        /** Default constructor */
        UsualRandomVector(const String & name = OT::DefaultName) : RandomVectorImplementation(name) {};

      private:

        /** The distribution the vector follows */
        Distribution distribution_;

      }; /* class UsualRandomVector */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_USUALRANDOMVECTOR_HXX */
