//                                               -*- C++ -*-
/**
 *  @file  LassoFactory.cxx
 *  @brief A factory for building Lasso objects
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: LassoFactory.hxx 1649 2010-11-09 12:44:00Z dutka $
 */

#include "LassoFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Algo {

      /* Default constructor */
      LassoFactory::LassoFactory()
        : ApproximationAlgorithmImplementationFactory()
      {
        // Nothing to do
      }

      /* Virtual constructor */
      LassoFactory * LassoFactory::clone() const
      {
        return new LassoFactory(*this);
      }

      /* String converter */
      String LassoFactory::__repr__() const
      {
        return OSS() << "class=" << GetClassName();
      }

      /* Method to create new Lasso objects */
      Lasso * LassoFactory::build(const NumericalSample & x,
				  const NumericalSample & y,
				  const NumericalPoint & weight,
				  const Basis & psi) const
      {
        return new Lasso( x, y, weight, psi );
      }


    } /* namespace Algo */
  } /* namespace Base */
} /* namespace OpenTURNS */
