//                                               -*- C++ -*-
/**
 *  @file  IdFactory.hxx
 *  @brief The class IdFactory builds unique Ids for all Objects
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: IdFactory.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_IDFACTORY_HXX
#define OPENTURNS_IDFACTORY_HXX

#include <iostream>              // for std::ostream
#include "OTprivate.hxx"
#include "AtomicFunctions.hxx"
#include "OStream.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class IdFactory
       *
       * @brief %IdFactory builds unique Ids for all PersistentObjects
       * @see PersistentObject
       * @see StorageManager
       *
       * The IdFactory ensures that each PersistentObject has an unique Id so they can be
       * distinguished from each other.
       * The IdFactory implements a 'singleton' strategy.
       */

      class IdFactory
      {
      public:

        /** Id accessor
         *
         * The way to get an Id for a new PersistentObject.
         */
        static Id BuildId();


      private:

        /** Default constructor */
        IdFactory();

        friend class IdFactory_init;
      }; /* class IdFactory */

      /** This struct initializes all static members of IdFactory */
      struct IdFactory_init {
        IdFactory_init();
      }; /* end class IdFactory_init */

      static IdFactory_init __IdFactory_initializer;

    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_IDFACTORY_HXX */
