//                                               -*- C++ -*-
/**
 *  @file  PlatformInfo.hxx
 *  @brief The class PlatformInfo gives information about the library
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: PlatformInfo.hxx 1910 2011-05-24 17:30:41Z schueller $
 */
#ifndef OPENTURNS_PLATFORMINFO_HXX
#define OPENTURNS_PLATFORMINFO_HXX

#include "OTprivate.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class PlatformInfo
       * @brief Defines static methods to query the library about various information (name, version, etc.)
       */

      class PlatformInfo
      {
      private:
        /**
         * The numerical precision used to write out scientific numbers
         */
        static int Precision_;

      public:

        /** Return the version number of Open TURNS */
        static String GetVersion();
        /** Return the name of the package Open TURNS was built from */
        static String GetName();
        /** Return the revision of the versioning system this version corresponds to (broken for the moment) */
        static String GetRevision();
        /** Return the date Open TURNS was built */
        static String GetDate();
        /** Return the path Open TURNS was installed to */
        static String GetInstallationDirectory();
        /** Return the path of the module standard directory */
        static String GetModuleDirectory();
        /** Return the versioning system id */
        static String GetId();
        /** Return the command line used to configure Open TURNS */
        static String GetConfigureCommandLine();
        /** Return the precision used for floating %point output */
        static int    GetNumericalPrecision();
        /** Define the precision used for floating %point output
         * @param precision An positive integer counting the number of digits shown
         */
        static void   SetNumericalPrecision(int precision);

      private:

        int precision_;

      public:

        PlatformInfo();  // Required by SWIG
        ~PlatformInfo(); // Required by SWIG

        /** @copydoc GetVersion() */
        String getVersion() const;
        /** @copydoc GetName() */
        String getName() const;
        /** @copydoc GetRevision() */
        String getRevision() const;
        /** @copydoc GetDate() */
        String getDate() const;
        /** @copydoc GetInstallationDirectory() */
        String getInstallationDirectory() const;
        /** @copydoc GetModuleDirectory() */
        String getModuleDirectory() const;
        /** @copydoc GetId() */
        String getId() const;
        /** @copydoc GetConfigureCommandLine() */
        String getConfigureCommandLine() const;
        /** @copydoc GetNumericalPrecision() */
        int    getNumericalPrecision() const;
        /** @copydoc SetNumericalPrecision() */
        void   setNumericalPrecision(int precision);

        /** @copydoc Object::__repr__() const */
        String __repr__() const;

        /** @copydoc Object::__str__() const */
        String __str__() const;

      }; /* class PlatformInfo */



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_PLATFORMINFO_HXX */
