//                                               -*- C++ -*-
/**
 *  @file  Threadable.hxx
 *  @brief The class Threadable defines an interface for multithreaded objects
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Threadable.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_THREADABLE_HXX
#define OPENTURNS_THREADABLE_HXX

#include "OTprivate.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Common
    {

      /**
       * @class Threadable
       * @brief Defined an interface for multithreaded classes
       * @internal
       *
       * Threadable is an interface (an abstract class) intended to
       * be derived by any class that need to be run in a multithreaded
       * environment.
       */

      class Threadable
      {
      public:

        /** Destructor */
        virtual ~Threadable();

        /**
         * The run method must be overloaded and populated with what
         * the actual (derived) class must do
         */
        virtual void run() = 0;
      }

        ; /* class Threadable */


    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_THREADABLE_HXX */
