//                                             -*- C++ -*-
/**
 *  @file  ConstantStep.cxx
 *  @brief Implementation of ConstantStep
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: slama $
 *  @date:   $LastChangedDate: 2008-11-19 16:10:42 +0100 (mer, 19 nov 2008) $
 *  Id:      $Id: ConstantStep.cxx 1023 2008-11-19 15:10:42Z slama $
 */

#include "ConstantStep.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Diff {

      CLASSNAMEINIT(ConstantStep);
      
      typedef Common::InvalidArgumentException            InvalidArgumentException;

      static Common::Factory<ConstantStep> RegisteredFactory("ConstantStep");

      /* Default constructor */
      ConstantStep::ConstantStep()
        : FiniteDifferenceStepImplementation()
      {
        // Nothing to do
      }

      /* Parameters constructor */
      ConstantStep::ConstantStep(const NumericalPoint & epsilon)
        : FiniteDifferenceStepImplementation(epsilon)
      {
        // Nothing to do
      }

      /* String converter */
      String ConstantStep::__repr__() const
      {
        OSS oss;
        oss << "class=" << ConstantStep::GetClassName()
            << " derived from " << FiniteDifferenceStepImplementation::__repr__();
        return oss;
      }

      /* Virtual constructor */
      ConstantStep * ConstantStep::clone() const
      {
        return new ConstantStep(*this);
      }

      /* Compute step */
      ConstantStep::NumericalPoint ConstantStep::operator()(const NumericalPoint & inP) const
      {
        const UnsignedLong dimension( inP.getDimension() );
        if (dimension != inP.getDimension()) throw InvalidArgumentException(HERE) << "Invalid dimension eps:" << dimension <<" x:" << inP.getDimension();
        return epsilon_;
      }

      /* Method save() stores the object through the StorageManager */
      void ConstantStep::save(StorageManager::Advocate & adv) const
      {
        FiniteDifferenceStepImplementation::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void ConstantStep::load(StorageManager::Advocate & adv)
      {
        FiniteDifferenceStepImplementation::load(adv);
      }

    }/* namespace Diff */
  }/* namespace Base */
}/* namespace OpenTURNS */


