//                                               -*- C++ -*-
/**
 * @file  AnalyticalNumericalMathEvaluationImplementation.hxx
 * @brief The class that implements the composition between numerical
 *        math functions implementations
 *
 * (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: schueller $
 * \date   $LastChangedDate: 2011-06-10 15:15:12 +0200 (Fri, 10 Jun 2011) $
 */

#ifndef OPENTURNS_ANALYTICALNUMERICALMATHEVALUATIONIMPLEMENTATION_HXX
#define OPENTURNS_ANALYTICALNUMERICALMATHEVALUATIONIMPLEMENTATION_HXX

#include "NumericalMathEvaluationImplementation.hxx"
#include "muParser.h"
#include "Pointer.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {


      /**
       * @class AnalyticalNumericalMathEvaluationImplementation
       *
       * The class that implement the composition of two numerical math functions implementations.
       */
      class AnalyticalNumericalMathEvaluationImplementation
        : public NumericalMathEvaluationImplementation
      {
        CLASSNAME;
      public:

        /* Some typedefs for easy reading */
        typedef NumericalMathEvaluationImplementation::NumericalPoint            NumericalPoint;
        typedef NumericalMathEvaluationImplementation::NumericalSample           NumericalSample;
        typedef mu::Parser                                                       Parser;
        typedef Type::Collection<Parser>                                         ParserCollection;
        typedef NumericalMathEvaluationImplementation::InvalidArgumentException  InvalidArgumentException;
        typedef NumericalMathEvaluationImplementation::InternalException         InternalException;
        typedef NumericalMathEvaluationImplementation::StorageManager            StorageManager;
        typedef Type::Collection<NumericalScalar>                                NumericalScalarCollection;

        /** Default constructor */
        AnalyticalNumericalMathEvaluationImplementation();

        /** Default constructor */
        AnalyticalNumericalMathEvaluationImplementation(const Description & inputVariablesNames,
                                                        const Description & outputVariablesNames,
                                                        const Description & formulas)
          /* throw(InvalidArgumentException) */;

        /** Virtual constructor */
        virtual AnalyticalNumericalMathEvaluationImplementation * clone() const;

        /** Comparison operator */
        Bool operator ==(const AnalyticalNumericalMathEvaluationImplementation & other) const;

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset = "") const;

        /** Operator () */
        using NumericalMathEvaluationImplementation::operator();
        NumericalPoint operator() (const NumericalPoint & inP) const
          /* throw(InvalidArgumentException, InternalException) */;

        /** Accessor for input point dimension */
        UnsignedLong getInputDimension() const
          /* throw(InternalException) */;

        /** Accessor for output point dimension */
        UnsignedLong getOutputDimension() const
          /* throw(InternalException) */;

        /** Get the i-th marginal function */
        AnalyticalNumericalMathEvaluationImplementation * getMarginal(const UnsignedLong i) const /* throw(InvalidArgumentException) */;

        /** Get the function corresponding to indices components */
        AnalyticalNumericalMathEvaluationImplementation * getMarginal(const Indices & indices) const /* throw(InvalidArgumentException) */;

        /** Accessor to the input variables names */
        Description getInputVariablesNames() const;

        /** Accessor to the output variables names */
        Description getOutputVariablesNames() const;

        /** Accessor to the formulas */
        Description getFormulas() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:

      private:
        friend class AnalyticalNumericalMathGradientImplementation;
        friend class AnalyticalNumericalMathHessianImplementation;
        /* Must initialize the parser at the first call to operator() as the
           reference associated with the variables may have change after the construction */
        void initialize() const;

        mutable Bool isInitialized_;
        mutable NumericalScalarCollection inputVariables_;
        Description inputVariablesNames_;
        Description outputVariablesNames_;
        Description formulas_;

        /** A mathematical expression parser from the muParser library */
        mutable ParserCollection parsers_;

      }; /* class AnalyticalNumericalMathEvaluationImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_ANALYTICALNUMERICALMATHEVALUATIONIMPLEMENTATION_HXX */
