//                                               -*- C++ -*-
/**
 *  @file  Basis.hxx
 *  @brief A collection of numerical math function
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2010-11-09 13:44:00 +0100 (Tue, 09 Nov 2010) $
 *  Id:      $Id: Basis.hxx 1649 2010-11-09 12:44:00Z dutka $
 */
#ifndef OPENTURNS_BASIS_HXX
#define OPENTURNS_BASIS_HXX

#include "PersistentCollection.hxx"
#include "NumericalMathFunction.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Func {

      /**
       * @class Basis
       *
       * A collection of numerical math function.
       */
      class Basis
        : public Type::PersistentCollection<NumericalMathFunction>
      {
        CLASSNAME;

      public:
        typedef Base::Common::StorageManager StorageManager;

        /** Default constructor */
        Basis();

        /** Constructor from a collection */
        Basis(const Type::Collection<NumericalMathFunction> & coll);

        /** String converter */
        virtual String __repr__() const;
        virtual String __str__(const String & offset = "") const;

        /** Dimension accessor */
        UnsignedLong getDimension() const;

        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);

      }; /* class Basis */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_BASIS_HXX */
