//                                               -*- C++ -*-
/**
 *  @file  DualLinearCombinationHessianImplementation.hxx
 *  @brief The hessian part of functional linear combination of vectors
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-05-21 17:44:02 +0200 (Wed, 21 May 2008) $
 *  Id:      $Id: Object.hxx 818 2008-05-21 15:44:02Z dutka $
 */
#ifndef OPENTURNS_DUALLINEARCOMBINATIONHESSIANIMPLEMENTATION_HXX
#define OPENTURNS_DUALLINEARCOMBINATIONHESSIANIMPLEMENTATION_HXX

#include "NumericalMathHessianImplementation.hxx"
#include "DualLinearCombinationEvaluationImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Func
    {

      /**
       * @class DualLinearCombinationHessianImplementation
       *
       * The hessian part of functional linear combination of vectors
       */

      class DualLinearCombinationHessianImplementation
        : public NumericalMathHessianImplementation
      {
        CLASSNAME;
      public:

        typedef Base::Common::StorageManager                                 StorageManager;
        typedef NumericalMathHessianImplementation::SymmetricTensor          SymmetricTensor;
        typedef NumericalMathHessianImplementation::NumericalPoint           NumericalPoint;
        typedef NumericalMathHessianImplementation::InvalidArgumentException InvalidArgumentException;
        typedef NumericalMathHessianImplementation::InternalException        InternalException;

        // friend class Base::Common::Factory<DualLinearCombinationHessianImplementation>;

        /** Default constructor */
        DualLinearCombinationHessianImplementation();

        /** Parameters constructor */
        DualLinearCombinationHessianImplementation(const DualLinearCombinationEvaluationImplementation & evaluation);

        /** Virtual constructor */
        DualLinearCombinationHessianImplementation * clone() const;

        /** Hessian method */
        SymmetricTensor hessian(const NumericalPoint & inP) const
          /* throw(InvalidArgumentException, InternalException) */;

        /** Accessor for input point dimension */
        UnsignedLong getInputDimension() const
          /* throw(InternalException) */;

        /** Accessor for output point dimension */
        UnsignedLong getOutputDimension() const
          /* throw(InternalException) */;

        /** String converter */
        String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);


      protected:

      private:
        /** The associated evaluation */
        DualLinearCombinationEvaluationImplementation evaluation_;

      } ; /* class DualLinearCombinationHessianImplementation */


    } /* namespace Func */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DUALLINEARCOMBINATIONHESSIANIMPLEMENTATION_HXX */
