//                                               -*- C++ -*-
/**
 *  @file  Pairs.hxx
 *  @brief Pairs class for piechart plots
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: lebrun $
 *  @date:   $LastChangedDate: 2011-02-26 21:12:17 +0100 (sam. 26 févr. 2011) $
 *  Id:      $Id: Pairs.hxx 1813 2011-02-26 20:12:17Z lebrun $
 */
#ifndef OPENTURNS_PAIRS_HXX
#define OPENTURNS_PAIRS_HXX

#include "OTprivate.hxx"
#include "Drawable.hxx"

namespace OpenTURNS {

  namespace Base {

    namespace Graph {

      /**
       * @class Pairs
       *
       * The class Pairs
       * Instance of Drawable
       */


      class Pairs : public DrawableImplementation
      {
        CLASSNAME;

      public:

        typedef DrawableImplementation::NumericalPoint           NumericalPoint;
        typedef DrawableImplementation::Description              Description;
        typedef DrawableImplementation::NumericalSample          NumericalSample;
        typedef DrawableImplementation::InvalidArgumentException InvalidArgumentException;

        /** Default constructor */
        Pairs(const NumericalSample & data,
              const String & title = NoSpecifiedLabel)
          /* throw(InvalidArgumentException) */;

        Pairs(const NumericalSample & data,
              const String & title,
              const Description labels,
              const String color,
              const String PointStyle);

        /** String converter */
        String __repr__() const;

        /** Accessor for first coordinate */
        NumericalSample getData() const;
        void setData(const NumericalSample & x);

        /** Accessor for labels */
        Description getLabels() const;
        void setLabels(const Description & labels)
          /* throw(InvalidArgumentException) */;

        /** Accessor for title */
        String getTitle() const;
        void setTitle(const String & title);
        /* throw(InvalidArgumentException) */;


        /** Check for data validity */
        Bool isValidData(const NumericalSample & data) const;

        /** Draw method */
        String draw() const;

        /** Clone method */
        Pairs * clone() const;

        /** Build default labels */
        void buildDefaultLabels();

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() stores the object through the StorageManager */
        void load(StorageManager::Advocate & adv);

        /** Clean all the temporary data created by draw() method */
        virtual void clean() const;

      private:

        Pairs() {};
        friend class Common::Factory<Pairs>;

        /** Labels of the level sets. If none is given, it defaults to the level values. */
        Description labels_;

        /** Title of the main */
        String title_;

        /** Temporary file name for the exchange with R */
        mutable String dataFileName_;

      }; /* class Pairs */

    }/* namespace Graph */

  }/*namespace Base */

}/* namespace OpenTURNS */

#endif /* OPENTURNS_PAIRS_HXX */
