//                                               -*- C++ -*-
/**
 *  @file  NearestPointCheckerResult.hxx
 *  @brief NearestPointCheckerResult stores the test result
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-08-01 13:42:13 +0200 (Mon, 01 Aug 2011) $
 *  Id:      $Id: NearestPointCheckerResult.hxx 2060 2011-08-01 11:42:13Z schueller $
 */
#ifndef OPENTURNS_NEARESTPOINTCHECKERRESULT_HXX
#define OPENTURNS_NEARESTPOINTCHECKERRESULT_HXX

#include "OTprivate.hxx"
#include "NumericalSample.hxx"
#include "PersistentObject.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

        /**
         * @class NearestPointCheckerResult
         * NearestPointCheckerResult stores the test result
         */
        class NearestPointCheckerResult:
          public Common::PersistentObject
        {
          CLASSNAME;
        public:
          typedef Stat::NumericalSample NumericalSample;
          
          /** Default constructor */
          NearestPointCheckerResult();

          /** Standard constructor */
          NearestPointCheckerResult(const NumericalSample & verifyingConstraintPoints,
                 const NumericalSample & verifyingConstraintValues,
                 const NumericalSample & violatingConstraintPoints,
                 const NumericalSample & violatingConstraintValues);


          /** Virtual constructor */
          virtual NearestPointCheckerResult * clone() const;

          /** Assigment operator */

          /** verifyingConstraintPoints accessor */
          NumericalSample  getVerifyingConstraintPoints() const;
          /** verifyingConstraintValues accessor */
          NumericalSample  getVerifyingConstraintValues() const;
          /** violatingConstraintPoints accessor */
          NumericalSample  getViolatingConstraintPoints() const;
          /** violatingConstraintValues accessor */
          NumericalSample  getViolatingConstraintValues() const;
          /** verifyingConstraintPoints accessor */
          void setVerifyingConstraintPoints(const NumericalSample & verifyingConstraintPoints);

          /** verifyingConstraintValues accessor */
          void setVerifyingConstraintValues(const NumericalSample & verifyingConstraintValues);

          /** violatingConstraintPoints accessor */
          void setViolatingConstraintPoints(const NumericalSample & violatingConstraintPoints);

          /** violatingConstraintValuess accessor */
          void setViolatingConstraintValues(const NumericalSample & violatingConstraintValues);

          /** String converter */
          String __repr__() const;

        private:


          NumericalSample verifyingConstraintPoints_;
          NumericalSample verifyingConstraintValues_;
          NumericalSample violatingConstraintPoints_;
          NumericalSample violatingConstraintValues_;

        }; // class NearestPointCheckerResult

    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NEARESTPOINTCHECKER_HXX */
