//                                               -*- C++ -*-
/**
 *  @file  TNC.hxx
 *  @brief TNC is an actual implementation for a bound-constrained optimization algorithm
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-05-24 19:30:41 +0200 (Tue, 24 May 2011) $
 *  Id:      $Id: TNC.hxx 1910 2011-05-24 17:30:41Z schueller $
 */
#ifndef OPENTURNS_TNC_HXX
#define OPENTURNS_TNC_HXX

#include "OTprivate.hxx"
#include "TNCSpecificParameters.hxx"
#include "BoundConstrainedAlgorithmImplementation.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Optim
    {

      /**
       * @class TNC
       * TNC is an actual implementation for
       * BoundConstrainedAlgorithm using the TNC library
       */
      class TNC :
        public BoundConstrainedAlgorithmImplementation
      {
        CLASSNAME;
      public:

        typedef BoundConstrainedAlgorithmImplementation::NumericalMathFunction NumericalMathFunction;
        typedef BoundConstrainedAlgorithmImplementation::InternalException     InternalException;
        typedef Base::Optim::TNCSpecificParameters                       TNCSpecificParameters;
        typedef BoundConstrainedAlgorithmImplementation::Result                Result;

        /** Default constructor */
        TNC();

        /** Constructor with parameters: no constraint, starting from the origin */
        TNC(const NumericalMathFunction & objectiveFunction,
            const Bool verbose = false);

        /** Constructor with parameters: bound constraints, starting from the given point */
        TNC(const TNCSpecificParameters & parameters,
            const NumericalMathFunction & objectiveFunction,
            const Interval & boundConstraints,
            const NumericalPoint & startingPoint,
            const OptimizationProblem optimization  = Result::MINIMIZATION,
            const Bool verbose = false) /* throw(InvalidArgumentException) */;

        /** Virtual constructor */
        virtual TNC * clone() const;

        /** Performs the actual computation. Must be overloaded by the actual optimisation algorithm */
        void run()
          /* throw(InternalException) */;

        /** Specific parameters accessor */
        TNCSpecificParameters getSpecificParameters() const;

        /** Specific parameters accessor */
        void setSpecificParameters(const TNCSpecificParameters & specificParameters);

        /** String converter */
        String __repr__() const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      private:

        /**
         * Function that computes the objective function and its gradient
         * corrected to correspond with the optimization problem (minimization or maximization)
         */
        static int ComputeObjectiveAndConstraint(double *x, double *f, double *g, void *state);

        TNCSpecificParameters specificParameters_;

      }; /* class TNC */


    } /* namespace Optim */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_TNC_HXX */
