//                                               -*- C++ -*-
/**
 *  @file  TestResult.hxx
 *  @brief TestResult implements the result of a statistical test
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: TestResult.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_TESTRESULT_HXX
#define OPENTURNS_TESTRESULT_HXX

#include "PersistentObject.hxx"
#include "StorageManager.hxx"
#include "Description.hxx"
#include "Exception.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Stat
    {

      /**
       * @class TestResult
       *
       * TestResult implements the result of a statistical test
       */

      class TestResult :
        public Common::PersistentObject
      {
        CLASSNAME;

      public:

        typedef Type::Description      Description;
        typedef Common::StorageManager StorageManager;

        /** Default constructor */
        TestResult();

        /** Parameters constructor */
        TestResult(const String & type,
                   const Bool binMeasure,
                   const NumericalScalar pVal,
                   const NumericalScalar pThreshold);


        /** Virtual constructor */
        virtual TestResult * clone() const;

        /** Description Accessor */
        void setDescription(const Description & description);
        Description getDescription() const;

        /** String converter */
        String __repr__() const;

        /** Elements accessors */
        Bool getBinaryQualityMeasure() const;
        NumericalScalar getPValue() const;
        NumericalScalar getThreshold() const;
        String getTestType() const;

        /** Comparison operator */
        Bool operator ==(const TestResult & other) const;

        /** Method save() stores the object through the StorageManager */
        void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        void load(StorageManager::Advocate & adv);

      protected:

        String testType_;
        Bool binaryQualityMeasure_ ;
        NumericalScalar pValueThreshold_ ;
        NumericalScalar pValue_ ;
        Description description_;

      }
        ; /* class TestResult */

    } /* namespace Stat */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_TESTRESULT_HXX */
