//                                               -*- C++ -*-
/**
 *  @file  NumericalPointWithDescription.hxx
 *  @brief NumericalPointWithDescription extends the classical mathematical point with a description of the coordinates
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: NumericalPointWithDescription.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX
#define OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX

#include "NumericalPoint.hxx"
#include "Description.hxx"
#include "Pointer.hxx"

namespace OpenTURNS
{

  namespace Base
  {

    namespace Type
    {

      /**
       * @class NumericalPointWithDescription
       *
       * NumericalPointWithDescription extends the classical mathematical point with a description of the coordinates
       */

      class NumericalPointWithDescription
        : public NumericalPoint
      {
        CLASSNAME;

      public:

        typedef Common::StorageManager StorageManager;

        /** Default constructor */
        NumericalPointWithDescription();

        /** Constructor with size */
        NumericalPointWithDescription(const UnsignedLong size,
                                      const NumericalScalar value = 0.0);

        /** Constructor from a collection */
        NumericalPointWithDescription(const Type::Collection<NumericalScalar> & coll);

        /** Constructor from a base class */
        NumericalPointWithDescription(const Pointer<NumericalPoint> & p_base);

        /** Virtual constructor */
        virtual NumericalPointWithDescription * clone() const;

        /** Destructor */
        virtual ~NumericalPointWithDescription() throw();

        /** Description Accessor */
        void setDescription(const Description & description);
        Description getDescription() const;

        /** String converter */
        String __repr__() const;
        String __str__(const String & offset = "") const;


        /** Method save() stores the object through the StorageManager */
        virtual void save(StorageManager::Advocate & adv) const;

        /** Method load() reloads the object from the StorageManager */
        virtual void load(StorageManager::Advocate & adv);

      private:

        /** The description of all components */
        Description description_;

      }; /* class NumericalPointWithDescription */



    } /* namespace Common */
  } /* namespace Base */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_NUMERICALPOINTWITHDESCRIPTION_HXX */
