//                                               -*- C++ -*-
/**
 *  @file  FixedExperiment.hxx
 *  @brief Abstract top-level view of an fixedExperiment plane
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2008-06-26 13:50:17 +0200 (jeu, 26 jun 2008) $
 *  Id:      $Id: FixedExperiment.hxx 862 2008-06-26 11:50:17Z dutka $
 */
#ifndef OPENTURNS_FIXEDEXPERIMENT_HXX
#define OPENTURNS_FIXEDEXPERIMENT_HXX

#include "WeightedExperiment.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {

      /**
       * @class FixedExperiment
       *
       * The class describes the probabilistic concept of fixedExperiment plan
       */
      class FixedExperiment
        : public WeightedExperiment
      {
        CLASSNAME;
      public:

        typedef WeightedExperiment::Distribution Distribution;

        /** Default constructor */
        explicit FixedExperiment(const String & name = OT::DefaultName);

        /** Parameters constructor */
        explicit FixedExperiment(const NumericalSample & sample,
                                 const String & name = OT::DefaultName);

        /** Parameters constructor */
        explicit FixedExperiment(const NumericalSample & sample,
                                 const NumericalPoint & weights,
                                 const String & name = OT::DefaultName);

        /** Virtual constructor */
        virtual FixedExperiment * clone() const;

        /** String converter */
        virtual String __repr__() const;

        /* Here is the interface that all derived class must implement */

        /** Distribution accessor */
        void setDistribution(const Distribution & distribution);

        /** Sample generation */
	using WeightedExperiment::generate;
        NumericalSample generate();

      protected:

      private:
        // The fixed sample that will be returned at each call
        NumericalSample sample_;

      }; /* class FixedExperiment */


    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_FIXEDEXPERIMENT_HXX */
