//                                               -*- C++ -*-
/**
 *  @file  NatafEllipticalDistributionGradient.cxx
 *  @brief Class for the Nataf transformation gradient for elliptical
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: NatafEllipticalDistributionGradient.cxx 1866 2011-04-11 10:32:27Z schueller $
 */
#include "OTprivate.hxx"
#include "NatafEllipticalDistributionGradient.hxx"
#include "PersistentObjectFactory.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Algorithm {


      /*
       * @class NatafEllipticalDistributionGradient
       *
       * This class offers an interface for the Nataf function for elliptical distributions
       */

      CLASSNAMEINIT(NatafEllipticalDistributionGradient);

      static Base::Common::Factory<NatafEllipticalDistributionGradient> RegisteredFactory("NatafEllipticalDistributionGradient");

      /* Default constructor */
      NatafEllipticalDistributionGradient::NatafEllipticalDistributionGradient():
        ConstantNumericalMathGradientImplementation()
      {
        // Nothing to do
      }

      /* Parameter constructor */
      NatafEllipticalDistributionGradient::NatafEllipticalDistributionGradient(const SquareMatrix & inverseCholesky):
        ConstantNumericalMathGradientImplementation(inverseCholesky.transpose())
      {
        // Nothing to do
      }

      /* String converter */
      String NatafEllipticalDistributionGradient::__repr__() const
      {
        return OSS() << "class=" << NatafEllipticalDistributionGradient::GetClassName()
                     << " inverseCholesky=" << getConstant().transpose();
      }

      /* Method save() stores the object through the StorageManager */
      void NatafEllipticalDistributionGradient::save(StorageManager::Advocate & adv) const
      {
        ConstantNumericalMathGradientImplementation::save(adv);
      }

      /* Method load() reloads the object from the StorageManager */
      void NatafEllipticalDistributionGradient::load(StorageManager::Advocate & adv)
      {
        ConstantNumericalMathGradientImplementation::load(adv);
      }

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */
