//                                               -*- C++ -*-
/**
 *  @file  QuasiMonteCarlo.hxx
 *  @brief Monte Carlo simulation using low-discrepancy sequences
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: dutka $
 *  @date:   $LastChangedDate: 2007-05-02 14:59:25 +0200 (Wed, 02 May 2007) $
 *  Id:      $Id: QuasiMonteCarlo.hxx 424 2007-05-02 12:59:25Z dutka $
 */
#ifndef OPENTURNS_QUASIMONTECARLO_HXX
#define OPENTURNS_QUASIMONTECARLO_HXX

#include "Simulation.hxx"
#include "LowDiscrepancySequence.hxx"
#include "SobolSequence.hxx"
#include "QuasiMonteCarloResult.hxx"

namespace OpenTURNS
{
  namespace Uncertainty
  {
    namespace Algorithm
    {
      /**
       * @class QuasiMonteCarlo
       */

      class QuasiMonteCarlo :
        public Simulation
      {
        CLASSNAME;

      public:
        typedef Simulation::NumericalSample                 NumericalSample;
        typedef Simulation::InvalidArgumentException        InvalidArgumentException;
        typedef Base::Type::Collection<Model::Distribution> Marginals;
        typedef Base::Stat::LowDiscrepancySequence          LowDiscrepancySequence;
        typedef Base::Stat::SobolSequence                   SobolSequence;

        /** Constructor with parameters */
        QuasiMonteCarlo(const Simulation::Event & event,
                        const LowDiscrepancySequence & lowDiscrepancySequence = SobolSequence());

        /** Virtual constructor */
        virtual QuasiMonteCarlo * clone() const;

        /** String converter */
        String __repr__() const;

      private:
        /** Compute the block sample */
        NumericalSample computeBlockSample(NumericalSample & realizedEventSample);

      protected:
        /** Antecedent dimension */
        UnsignedLong dimension_;

        /** Sequence used to generate the low discrepancy points */
        LowDiscrepancySequence lowDiscrepancySequence_;

        /** Marginal distributions */
        Marginals marginals_;

      } ; /* class QuasiMonteCarlo */

    } /* namespace Algorithm */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_QUASIMONTECARLO_HXX */
