//                                               -*- C++ -*-
/**
 *  @file  DiscreteDistribution.hxx
 *  @brief Abstract top-level class for Discrete distributions
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: DiscreteDistribution.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_DISCRETEDISTRIBUTION_HXX
#define OPENTURNS_DISCRETEDISTRIBUTION_HXX

#include "OTprivate.hxx"
#include "UsualDistribution.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class DiscreteDistribution
       *
       * A subclass for Discrete usual distributions.
       */
      class DiscreteDistribution
        : public UsualDistribution
      {
        CLASSNAME;
      public:

        typedef UsualDistribution::InvalidArgumentException InvalidArgumentException;
        typedef UsualDistribution::NumericalPoint           NumericalPoint;
        typedef UsualDistribution::NumericalSample          NumericalSample;

        // Tolerance relative to point support (i.e. to absorb round-off errors)
        static const NumericalScalar SupportEpsilon;
        /** Default constructor */
        explicit DiscreteDistribution(const String & name = OT::DefaultName);


        /** Virtual constructor */
        virtual DiscreteDistribution * clone() const;

        /** Comparison operator */
        Bool operator ==(const DiscreteDistribution & other) const;

        /** String converter */
        String __repr__() const;

        /* Methods inherited from upper classes */

        /** Tell if the distribution is continuous */
        Bool isContinuous() const;

        /** Tell if the distribution is integer valued */
        Bool isIntegral() const;

        /** Draw the PDF of the distribution */
        using DistributionImplementation::drawPDF;
        virtual Graph drawPDF(const NumericalScalar xMin,
                              const NumericalScalar xMax,
                              const UnsignedLong pointNumber = DefaultPointNumber) const;

        /** Draw the CDF of the distribution */
        using DistributionImplementation::drawCDF;
        virtual Graph drawCDF(const NumericalScalar xMin,
                              const NumericalScalar xMax,
                              const UnsignedLong pointNumber = DefaultPointNumber) const;

      protected:


      private:

      }; /* class DiscreteDistribution */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DISCRETEDISTRIBUTION_HXX */
