//                                               -*- C++ -*-
/**
 * @file  DistributionFactory.hxx
 * @brief Top-level class for all distribution factories
 *
 * (C) Copyright 2005-2011 EDF
 *
 * Permission to copy, use, modify, sell and distribute this software
 * is granted provided this copyright notice appears in all copies.
 * This software is provided "as is" without express or implied
 * warranty, and with no claim as to its suitability for any purpose.
 *
 *
 * \author $LastChangedBy: schueller $
 * \date   $LastChangedDate: 2011-07-28 18:31:43 +0200 (Thu, 28 Jul 2011) $
 */

#ifndef OPENTURNS_DISTRIBUTIONFACTORY_HXX
#define OPENTURNS_DISTRIBUTIONFACTORY_HXX

#include "DistributionImplementationFactory.hxx"
#include "Distribution.hxx"
#include "TypedInterfaceObject.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {

      /**
       * @class DistributionFactory
       */
      class DistributionFactory
        : public Base::Common::TypedInterfaceObject<DistributionImplementationFactory>
      {
        CLASSNAME;
      public:

        typedef DistributionImplementationFactory::NumericalSample                         NumericalSample;
        typedef DistributionImplementationFactory::InternalException                       InternalException;
        typedef DistributionImplementationFactory::InvalidArgumentException                InvalidArgumentException;
        typedef DistributionImplementationFactory::NumericalPointCollection                NumericalPointCollection;
        typedef DistributionImplementationFactory::NumericalPointWithDescriptionCollection NumericalPointWithDescriptionCollection;

        /** Default constructor */
        DistributionFactory(const UnsignedLong bootstrapSize = DistributionImplementationFactory::DefaultBootstrapSize,
                            const String & name = OT::DefaultName);

        /** Parameter constructor */
        DistributionFactory(const DistributionImplementationFactory & factory);

        /** String converter */
        virtual String __repr__() const;

        /** String converter */
        virtual String __str__(const String & offset = "") const;

        /* Here is the interface that all derived class must implement */

        virtual Distribution build(const NumericalSample & sample) const /* throw(InvalidArgumentException, InternalException) */;
        virtual Distribution build(const NumericalPointCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
        virtual Distribution build(const NumericalPointWithDescriptionCollection & parameters) const /* throw(InvalidArgumentException, InternalException) */;
        virtual Distribution build() const /* throw(InvalidArgumentException, InternalException) */;

      private:

      }; /* class DistributionFactory */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_DISTRIBUTIONFACTORY_HXX */
