//                                               -*- C++ -*-
/**
 *  @file  Event.hxx
 *  @brief This class specializes the concept of RandomVector by constructing a Bernoulli
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-04-11 12:32:27 +0200 (Mon, 11 Apr 2011) $
 *  Id:      $Id: Event.hxx 1866 2011-04-11 10:32:27Z schueller $
 */
#ifndef OPENTURNS_EVENT_HXX
#define OPENTURNS_EVENT_HXX

#include "RandomVector.hxx"
#include "Pointer.hxx"

namespace OpenTURNS {

  namespace Uncertainty {

    namespace Model {


      /**
       * @class Event
       *
       * The class that implements all random vectors
       */
      class Event
        : public RandomVector
      {
        CLASSNAME;

      public:

        typedef RandomVector::ComparisonOperator       ComparisonOperator;
        typedef RandomVector::InvalidArgumentException InvalidArgumentException;

        /** for save/load mecanism */
        Event();

        /** Constructor from RandomVector */
        Event(const RandomVector & antecedent,
              const ComparisonOperator & op,
              const NumericalScalar threshold,
              const String & name = OT::DefaultName)
          /* throw (InvalidArgumentException) */;


        /** String converter */
        String __repr__() const;

        /** String converter */
        String __str__(const String & offset = "") const;

      private:

      }; /* class Event */


    } /* namespace Model */
  } /* namespace Uncertainty */
} /* namespace OpenTURNS */

#endif /* OPENTURNS_EVENT_HXX */
