//                                               -*- C++ -*-
/**
 * @file  t_ComputedNumericalMathEvaluationImplementation_std.cxx
 * @brief The test file of class ComputedNumericalMathEvaluationImplementation for standard methods
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-06-01 17:59:24 +0200 (Wed, 01 Jun 2011) $
 *  Id:      $Id: t_ComputedNumericalMathEvaluationImplementation_std.cxx 1920 2011-06-01 15:59:24Z schueller $
 */

#include <iostream>
#include <sstream>
#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "ComputedNumericalMathEvaluationImplementation.hxx"
#include "Exception.hxx"

using namespace OT;
using namespace OT::Test;
using namespace OT::Base::Common;
using namespace OT::Base::Type;
using namespace OT::Base::Func;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {

    try {
      // Test basic functionnalities
      //checkClassWithClassName<ComputedNumericalMathEvaluationImplementation>();

      // Test some extra functionnalities
      //checkNameFeature<ComputedNumericalMathEvaluationImplementation>();


      // Test function operator ()
      // ComputedNumericalMathEvaluationImplementation myFunction("wrapper");
      ComputedNumericalMathEvaluationImplementation myFunctionImpl = ComputedNumericalMathEvaluationImplementation( "wrapper", WrapperFile::FindWrapperByName( "wrapper" ) );
      NumericalPoint inPoint(2);
      inPoint[0] = 10;
      inPoint[1] = 10;
      NumericalPoint outPoint = myFunctionImpl( inPoint );
      fullprint << myFunctionImpl.getName() << "( " << inPoint << " ) = " << outPoint << std::endl;
    }
    catch (NoWrapperFileFoundException & ex) {
      throw TestFailed(ex.__repr__());
    }


  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }

  return ExitCode::Success;
}
