//                                               -*- C++ -*-
/**
 *  @file  t_FunctionCache.cxx
 *  @brief The test file of FunctionCache
 *
 *  (C) Copyright 2005-2011 EDF-EADS-Phimeca
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License.
 *
 *  This library is distributed in the hope that it will be useful
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 *  @author: $LastChangedBy: schueller $
 *  @date:   $LastChangedDate: 2011-01-26 14:50:44 +0100 (Wed, 26 Jan 2011) $
 *  Id:      $Id: t_FunctionCache.cxx 1730 2011-01-26 13:50:44Z schueller $
 */

#include <exception>
#include "OT.hxx"
#include "OTtestcode.hxx"
#include "OStream.hxx"
#include "FunctionCache.hxx"
#include "NumericalPoint.hxx"
#include "NumericalSample.hxx"

using namespace OT::Test;
using namespace OT::Base::Type;
using namespace OT::Base::Func;
using namespace OT::Base::Common;
using namespace OT::Base::Stat;

int main(int argc, char *argv[])
{
  TESTPREAMBLE;
  OStream fullprint(std::cout);

  try {
    FunctionCache myCache(10);
    myCache.enable();

    NumericalPoint point1(2);
    point1[0]=1;
    point1[1]=-1;

    NumericalPoint value1(1);
    value1[0]=2;

    myCache.add( point1, value1 );

    NumericalPoint point2(2);
    point2[0]=2;
    point2[1]=-2;

    NumericalPoint value2(1);
    value2[0]=4;

    myCache.add( point2, value2 );

    NumericalSample inputCacheSample(myCache.getInputNumericalSample());
    fullprint << "input cache sample =" << inputCacheSample << std::endl;

    NumericalSample outputCacheSample(myCache.getOutputNumericalSample());
    fullprint << "output cache sample =" << outputCacheSample << std::endl;

    NumericalPoint newInput(2);
    newInput[0] = 9.0;
    newInput[1] = 8.0;

    NumericalPoint newOutput(1);
    newOutput[0] = 7.0;

    inputCacheSample.add( newInput );
    outputCacheSample.add( newOutput );

    myCache.importFromNumericalSample(inputCacheSample, outputCacheSample);

    fullprint << "input cache from imported sample =" << myCache.getInputNumericalSample() << std::endl;
    fullprint << "output cache from imported sample =" << myCache.getOutputNumericalSample() << std::endl;

  }
  catch (TestFailed & ex) {
    std::cerr << ex << std::endl;
    return ExitCode::Error;
  }


  return ExitCode::Success;
}
